/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep.config;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public class Strings {
    private static final Pattern QueryParam = Pattern.compile("^([^=]+)=(.*)$");
    private static final Pattern SimpleVar = Pattern.compile("\\$([-_.a-zA-Z0-9]+)");
    private static final Pattern ParenVar = Pattern.compile("\\$\\(([^\\(\\)]+)\\)");
    private static final Pattern AtPeriod = Pattern.compile("^(\\d+)([a-z]+)$");
    private static final Pattern IsoPeriod = Pattern.compile("^(P.*)$");
    private static final Pattern IsoDate = Pattern.compile("^(\\d{4}-.*)$");
    private static final Pattern RelativeDate = Pattern.compile("^([a-z]+)([\\-+])(.+)$");
    private static final Pattern NamedDate = Pattern.compile("^([a-z]+)$");
    private static final Pattern UnixDate = Pattern.compile("^([0-9]+)$");
    private static final DateTime epoch = new DateTime(0L, DateTimeZone.UTC);
    private static final DateTimeFormatter isoDateFmt = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC);
    private static final PeriodFormatter isoPeriodFmt = ISOPeriodFormat.standard();

    private Strings() {
    }

    public static String join(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        for (String string3 : list) {
            stringBuilder.append(string2).append(string3);
            string2 = string;
        }
        return stringBuilder.toString();
    }

    public static boolean conversionExists(Class clazz) {
        return clazz == String.class || clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE || clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == DateTime.class || clazz == DateTimeZone.class || clazz == Duration.class || clazz == Period.class || clazz == Pattern.class;
    }

    public static <T> T cast(Class<T> clazz, String string) {
        if (clazz == String.class) {
            return (T)string;
        }
        if (clazz == Boolean.TYPE) {
            return (T)Boolean.valueOf(string);
        }
        if (clazz == Byte.TYPE) {
            return (T)Byte.valueOf(string);
        }
        if (clazz == Short.TYPE) {
            return (T)Short.valueOf(string);
        }
        if (clazz == Integer.TYPE) {
            return (T)Integer.valueOf(string);
        }
        if (clazz == Long.TYPE) {
            return (T)Long.valueOf(string);
        }
        if (clazz == Float.TYPE) {
            return (T)Float.valueOf(string);
        }
        if (clazz == Double.TYPE) {
            return (T)Double.valueOf(string);
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.valueOf(string);
        }
        if (clazz == Byte.class) {
            return (T)Byte.valueOf(string);
        }
        if (clazz == Short.class) {
            return (T)Short.valueOf(string);
        }
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(string);
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(string);
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(string);
        }
        if (clazz == Double.class) {
            return (T)Double.valueOf(string);
        }
        if (clazz == DateTime.class) {
            return (T)Strings.parseDate(string);
        }
        if (clazz == DateTimeZone.class) {
            return (T)DateTimeZone.forID((String)string);
        }
        if (clazz == Duration.class) {
            return (T)Strings.parseDuration(string);
        }
        if (clazz == Period.class) {
            return (T)Strings.parsePeriod(string);
        }
        if (clazz == Pattern.class) {
            return (T)Pattern.compile(string);
        }
        throw new IllegalArgumentException("unsupported property type " + clazz.getName());
    }

    public static DateTime parseDate(String string) {
        return Strings.parseDate(string, DateTimeZone.UTC);
    }

    public static DateTime parseDate(String string, DateTimeZone dateTimeZone) {
        return Strings.parseDate(new DateTime(dateTimeZone), string, dateTimeZone);
    }

    public static DateTime parseDate(DateTime dateTime, String string, DateTimeZone dateTimeZone) {
        Matcher matcher = IsoDate.matcher(string);
        if (matcher.matches()) {
            return isoDateFmt.withZone(dateTimeZone).parseDateTime(matcher.group(1));
        }
        matcher = RelativeDate.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            if (string3.equals("-")) {
                return Strings.parseRefVar(dateTime, string2).minus((ReadablePeriod)Strings.parsePeriod(string4));
            }
            if (string3.equals("+")) {
                return Strings.parseRefVar(dateTime, string2).plus((ReadablePeriod)Strings.parsePeriod(string4));
            }
            throw new IllegalArgumentException("invalid operation " + string3);
        }
        matcher = NamedDate.matcher(string);
        if (matcher.matches()) {
            return Strings.parseRefVar(dateTime, matcher.group(1));
        }
        matcher = UnixDate.matcher(string);
        if (matcher.matches()) {
            return new DateTime(Long.valueOf(matcher.group(1)) * 1000L, DateTimeZone.UTC);
        }
        throw new IllegalArgumentException("invalid date " + string);
    }

    private static DateTime parseRefVar(DateTime dateTime, String string) {
        if (string.equals("now")) {
            return new DateTime();
        }
        if (string.equals("epoch")) {
            return epoch;
        }
        return dateTime;
    }

    public static Duration parseDuration(String string) {
        return Strings.parsePeriod(string).toStandardDuration();
    }

    public static Period parsePeriod(String string) {
        Matcher matcher = AtPeriod.matcher(string);
        if (matcher.matches()) {
            return Strings.parseAtPeriod(matcher.group(1), matcher.group(2));
        }
        matcher = IsoPeriod.matcher(string);
        if (matcher.matches()) {
            return isoPeriodFmt.parsePeriod(matcher.group(1));
        }
        throw new IllegalArgumentException("invalid period " + string);
    }

    private static Period parseAtPeriod(String string, String string2) {
        int n = Integer.valueOf(string);
        if (string2.equals("s") || string2.equals("second") || string2.equals("seconds")) {
            return Period.seconds((int)n);
        }
        if (string2.equals("m") || string2.equals("min") || string2.equals("minute") || string2.equals("minutes")) {
            return Period.minutes((int)n);
        }
        if (string2.equals("h") || string2.equals("hour") || string2.equals("hours")) {
            return Period.hours((int)n);
        }
        if (string2.equals("d") || string2.equals("day") || string2.equals("days")) {
            return Period.days((int)n);
        }
        if (string2.equals("w") || string2.equals("wk") || string2.equals("week") || string2.equals("weeks")) {
            return Period.weeks((int)n);
        }
        if (string2.equals("month") || string2.equals("months")) {
            return Period.months((int)n);
        }
        if (string2.equals("y") || string2.equals("year") || string2.equals("years")) {
            return Period.years((int)n);
        }
        throw new IllegalArgumentException("unknown unit " + string2);
    }
}

