/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep.config;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.netflix.iep.config.ConfigFile;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopedPropertiesLoader {
    private static Logger LOGGER = LoggerFactory.getLogger(ScopedPropertiesLoader.class);
    private static final String PROP_PROPERTIES_FILE = "netflix.iep.config.propertiesFile";
    private static final String DEF_PROPERTIES_FILE = "application.scoped.properties";

    public static Properties load() {
        String[] stringArray = System.getProperty(PROP_PROPERTIES_FILE, DEF_PROPERTIES_FILE).split(",");
        return ScopedPropertiesLoader.load(stringArray);
    }

    public static Properties load(String[] stringArray) {
        Object object;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            try {
                arrayList.add(Resources.getResource((String)object));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.debug("ignoring " + (String)object + " - does not exist");
            }
        }
        StringBuilder stringBuilder = new StringBuilder("# Generated properties\n");
        object = new Properties();
        for (URL uRL : arrayList) {
            String string;
            LOGGER.debug("loading properties from " + uRL);
            try {
                string = Resources.toString((URL)uRL, (Charset)Charsets.UTF_8);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            String string2 = ConfigFile.toPropertiesString(System.getenv(), string);
            stringBuilder.append(string2).append("\n");
            Properties properties = ConfigFile.loadProperties(System.getenv(), string);
            LOGGER.debug("loading properties: " + properties);
            ((Properties)object).putAll((Map<?, ?>)properties);
            LOGGER.info("loaded properties file " + uRL);
        }
        LOGGER.debug("properties debug: " + stringBuilder);
        return object;
    }
}

