/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep.config;

import com.netflix.archaius.Property;
import com.netflix.archaius.PropertyFactory;
import com.netflix.iep.config.Configuration;
import com.netflix.iep.config.IConfiguration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DynamicPropertiesConfiguration {
    private final IConfiguration instance;

    @Inject
    public DynamicPropertiesConfiguration(PropertyFactory propertyFactory) {
        this.instance = new DynamicPropertiesConfigurationInstance(propertyFactory);
        Configuration.setConfiguration(this.instance);
    }

    protected IConfiguration getInstance() {
        return this.instance;
    }

    @PreDestroy
    public void destroy() {
        Configuration.setConfiguration(null);
    }

    protected class DynamicPropertiesConfigurationInstance
    implements IConfiguration {
        private final PropertyFactory factory;
        private final Map<String, Property<String>> props = new ConcurrentHashMap<String, Property<String>>();

        protected DynamicPropertiesConfigurationInstance(PropertyFactory propertyFactory) {
            this.factory = propertyFactory;
        }

        @Override
        public String get(String string) {
            Property property = this.props.get(string);
            if (property == null) {
                property = this.factory.getProperty(string).asString(null);
                this.props.put(string, (Property<String>)property);
            }
            return (String)property.get();
        }
    }
}

