/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep.config;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.util.Modules;
import com.netflix.archaius.config.CompositeConfig;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.config.PollingDynamicConfig;
import com.netflix.archaius.config.PollingStrategy;
import com.netflix.archaius.config.polling.FixedPollingStrategy;
import com.netflix.archaius.config.polling.PollingResponse;
import com.netflix.archaius.guice.ArchaiusModule;
import com.netflix.archaius.inject.ApplicationLayer;
import com.netflix.archaius.inject.RemoteLayer;
import com.netflix.archaius.typesafe.TypesafeConfig;
import com.netflix.iep.config.DynamicPropertiesConfiguration;
import com.netflix.iep.config.ScopedPropertiesLoader;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;

public class DynamicNoOpConfigModule
extends AbstractModule {
    private final String[] propFiles;

    public DynamicNoOpConfigModule() {
        this(null);
    }

    public DynamicNoOpConfigModule(String[] stringArray) {
        this.propFiles = stringArray;
    }

    protected void configure() {
        Module module = Modules.override((Module[])new Module[]{new ArchaiusModule()}).with(new Module[]{new OverrideModule(this.propFiles)});
        this.install(module);
    }

    public boolean equals(Object object) {
        return object != null && ((Object)((Object)this)).getClass().equals(object.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    private static class OverrideModule
    extends AbstractModule {
        private final String[] propFiles;

        OverrideModule(String[] stringArray) {
            this.propFiles = stringArray;
        }

        protected void configure() {
            this.bind(DynamicPropertiesConfiguration.class).asEagerSingleton();
        }

        @Provides
        @Singleton
        Config providesTypesafeConfig() {
            Config config = ConfigFactory.load();
            String string = "iep-" + config.getString("netflix.iep.env.account-type");
            return ConfigFactory.load((String)string).withFallback((ConfigMergeable)config);
        }

        @Provides
        @Singleton
        @RemoteLayer
        private com.netflix.archaius.Config providesOverrideConfig(Config config) throws Exception {
            return new PollingDynamicConfig(new Callable(){

                public PollingResponse call() {
                    return PollingResponse.noop();
                }
            }, (PollingStrategy)new FixedPollingStrategy(60000L, TimeUnit.MILLISECONDS));
        }

        @Provides
        @Singleton
        @ApplicationLayer
        private CompositeConfig providesAppConfig(Config config) throws Exception {
            Properties properties = this.propFiles == null ? ScopedPropertiesLoader.load() : ScopedPropertiesLoader.load(this.propFiles);
            CompositeConfig compositeConfig = new CompositeConfig();
            compositeConfig.addConfig("scoped", (com.netflix.archaius.Config)new MapConfig(properties));
            compositeConfig.addConfig("typesafe", (com.netflix.archaius.Config)new TypesafeConfig(config));
            return compositeConfig;
        }
    }
}

