/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep.config;

import com.netflix.iep.config.DefaultValue;
import com.netflix.iep.config.IConfiguration;
import com.netflix.iep.config.Strings;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private static volatile IConfiguration iConfiguration = new IConfiguration(){

        @Override
        public String get(String string) {
            throw new IllegalStateException("configuration has not been set");
        }
    };

    static void setConfiguration(IConfiguration iConfiguration) {
        Configuration.iConfiguration = iConfiguration;
    }

    public static <T> T apply(Class<T> clazz) {
        String string = clazz.getPackage().getName();
        String string2 = string.startsWith("com.") ? string.substring("com.".length()) : string;
        return Configuration.newProxy(clazz, string2);
    }

    public static <T> T newProxy(Class<T> clazz, final String string) {
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                String string5;
                if (method.getName().equals("get")) {
                    return iConfiguration.get(objectArray[0] == null ? null : objectArray[0].toString());
                }
                Class<?> clazz = method.getReturnType();
                String string2 = string5 = string == null ? method.getName() : string + "." + method.getName();
                if (IConfiguration.class.isAssignableFrom(clazz)) {
                    return Configuration.newProxy(clazz, string5);
                }
                String string3 = iConfiguration.get(string5);
                if (string3 == null) {
                    DefaultValue defaultValue = method.getAnnotation(DefaultValue.class);
                    String string4 = string3 = defaultValue == null ? null : defaultValue.value();
                }
                if (string3 == null) {
                    if (clazz.isPrimitive()) {
                        throw new IllegalStateException("no value for property " + method.getName());
                    }
                    return null;
                }
                return Strings.cast(clazz, string3);
            }
        };
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler);
    }
}

