/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep.config;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.TreeSet;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class ConfigFile {
    public static boolean checkScope(Map<String, String> map, String string) {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager(null);
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("javascript");
        if (scriptEngine == null) {
            throw new IllegalStateException("no javascipt engine found");
        }
        SimpleBindings simpleBindings = new SimpleBindings();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            simpleBindings.put(entry.getKey(), (Object)entry.getValue());
        }
        try {
            return (Boolean)scriptEngine.eval(string, (Bindings)simpleBindings);
        }
        catch (ScriptException scriptException) {
            throw new RuntimeException(scriptException);
        }
    }

    public static Map<String, String> loadUsingEnv(File file) {
        return ConfigFile.load(System.getenv(), file);
    }

    public static Map<String, String> loadUsingEnv(String string) {
        return ConfigFile.load(System.getenv(), string);
    }

    public static Properties loadPropertiesUsingEnv(File file) {
        return ConfigFile.loadProperties(System.getenv(), file);
    }

    public static Properties loadPropertiesUsingEnv(String string) {
        return ConfigFile.loadProperties(System.getenv(), string);
    }

    public static Map<String, String> load(Map<String, String> map, File file) {
        try {
            return ConfigFile.load(map, Files.toString((File)file, (Charset)Charsets.UTF_8));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Map<String, String> load(Map<String, String> map, String string) {
        Properties properties = ConfigFile.loadProperties(map, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : properties.stringPropertyNames()) {
            hashMap.put(string2, properties.getProperty(string2));
        }
        return hashMap;
    }

    public static Properties loadProperties(Map<String, String> map, File file) {
        try {
            return ConfigFile.loadProperties(map, Files.toString((File)file, (Charset)Charsets.UTF_8));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Properties loadProperties(Map<String, String> map, String string) {
        String string2 = ConfigFile.toPropertiesString(map, string);
        Properties properties = new Properties();
        StringReader stringReader = new StringReader(string2);
        try {
            properties.load(stringReader);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (stringReader != null) {
                try {
                    ((Reader)stringReader).close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public static String toPropertiesString(Map<String, String> map, File file) {
        try {
            return ConfigFile.toPropertiesString(map, Files.toString((File)file, (Charset)Charsets.UTF_8));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String toPropertiesString(Map<String, String> map, String string) {
        List<ConfigLine> list = ConfigFile.parse(map, string);
        List<ConfigLine> list2 = ConfigFile.applyOverrides(ConfigFile.filterByScope(list));
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
        for (String charSequence2 : treeSet) {
            arrayList.add(charSequence2 + " = [" + map.get(charSequence2) + "]");
        }
        String string2 = ConfigFile.mkCommentString(arrayList, "vars", "\n\n");
        StringBuffer stringBuffer = new StringBuffer(string2);
        for (ConfigLine configLine : list2) {
            stringBuffer.append(configLine.getLine()).append("\n");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static List<ConfigLine> applyOverrides(List<ConfigLine> list) {
        ArrayList<PropertyLine> arrayList = new ArrayList<PropertyLine>();
        ArrayList<ConfigLine> arrayList2 = new ArrayList<ConfigLine>();
        for (ConfigLine object2 : list) {
            if (object2.isProperty) {
                arrayList.add((PropertyLine)object2);
                continue;
            }
            arrayList2.add(object2);
        }
        Comparator<ConfigLine> comparator = new Comparator<ConfigLine>(){

            @Override
            public int compare(ConfigLine configLine, ConfigLine configLine2) {
                return configLine.pos - configLine2.pos;
            }
        };
        HashMap hashMap = new HashMap();
        for (PropertyLine propertyLine : arrayList) {
            void var7_10;
            TreeSet treeSet = (TreeSet)hashMap.get(propertyLine.name);
            if (treeSet == null) {
                TreeSet treeSet2 = new TreeSet(comparator);
                hashMap.put(propertyLine.name, treeSet2);
            }
            var7_10.add(propertyLine);
        }
        TreeSet treeSet = new TreeSet(comparator);
        for (Map.Entry entry : hashMap.entrySet()) {
            NavigableSet navigableSet = ((TreeSet)entry.getValue()).descendingSet();
            PropertyLine propertyLine = (PropertyLine)navigableSet.pollFirst();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (PropertyLine propertyLine2 : navigableSet) {
                arrayList3.add("[" + propertyLine2.getScope().expr + "] => [" + propertyLine2.value + "]");
            }
            treeSet.add(propertyLine.withOverrides(arrayList3));
        }
        for (ConfigLine configLine : arrayList2) {
            treeSet.add(configLine);
        }
        return new ArrayList<ConfigLine>(treeSet);
    }

    private static List<ConfigLine> filterByScope(List<ConfigLine> list) {
        boolean bl = true;
        ArrayList<ConfigLine> arrayList = new ArrayList<ConfigLine>();
        for (ConfigLine configLine : list) {
            if (configLine instanceof Scope) {
                bl = ((Scope)configLine).matches;
                arrayList.add(0, configLine);
                continue;
            }
            if (!bl) continue;
            arrayList.add(0, configLine);
        }
        return arrayList;
    }

    private static List<ConfigLine> parse(Map<String, String> map, String string) {
        ArrayList<ConfigLine> arrayList = new ArrayList<ConfigLine>();
        String[] stringArray = string.split("\n");
        Scope scope = new Scope("default", 0, true);
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = string2.trim();
            if (bl) {
                stringBuilder.append("\n").append(string2);
                if (string3.endsWith("\\")) continue;
                arrayList.add(ConfigFile.mkProperty(stringBuilder.toString(), i, scope));
                stringBuilder = new StringBuilder();
                continue;
            }
            if (string3.startsWith("# scope:")) {
                String string4 = string3.substring("# scope:".length()).trim();
                scope = new Scope(string4, i, ConfigFile.checkScope(map, string4));
                arrayList.add(scope);
                continue;
            }
            if (string3.startsWith("#")) {
                arrayList.add(new Comment(string3, i, scope));
                continue;
            }
            if (string3.length() == 0) {
                arrayList.add(new EmptyLine(string3, i, scope));
                continue;
            }
            if (string3.endsWith("\\")) {
                bl = true;
                stringBuilder.append(string3);
                continue;
            }
            arrayList.add(ConfigFile.mkProperty(string3, i, scope));
        }
        return arrayList;
    }

    private static String mkCommentString(List<String> list, String string, String string2) {
        String string3 = "\n# --> ";
        StringBuilder stringBuilder = new StringBuilder("# ").append(string).append(":");
        for (String string4 : list) {
            stringBuilder.append(string3).append(string4.toString());
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private static ConfigLine mkProperty(String string, int n, Scope scope) {
        int n2 = string.indexOf("=");
        if (n2 < 1 || n2 > string.length() - 2) {
            throw new IllegalStateException("invalid property line: [" + string + "]");
        }
        String string2 = string.substring(0, n2).trim();
        String string3 = string.substring(n2 + 1);
        if (string3.equals("null")) {
            return new Delete(string2, n, scope);
        }
        return new Property(string2, string3, n, scope);
    }

    private static class EmptyLine
    extends ConfigLine {
        EmptyLine(String string, int n, Scope scope) {
            this.line = string;
            this.pos = n;
            this.scope = scope;
        }
    }

    private static class Comment
    extends ConfigLine {
        Comment(String string, int n, Scope scope) {
            this.line = string;
            this.pos = n;
            this.scope = scope;
        }
    }

    private static class Delete
    extends PropertyLine {
        Delete(String string, int n, Scope scope) {
            this(string, n, scope, null);
        }

        Delete(String string, int n, Scope scope, List<String> list) {
            this.name = string;
            this.value = null;
            this.pos = n;
            this.scope = scope;
            this.overrides = list;
        }

        @Override
        String lineString() {
            return "# deleted: " + this.name;
        }

        @Override
        PropertyLine withOverrides(List<String> list) {
            return new Delete(this.name, this.pos, this.scope, list);
        }
    }

    private static class Property
    extends PropertyLine {
        Property(String string, String string2, int n, Scope scope) {
            this(string, string2, n, scope, null);
        }

        Property(String string, String string2, int n, Scope scope, List<String> list) {
            this.name = string;
            this.value = string2;
            this.pos = n;
            this.scope = scope;
            this.overrides = list;
        }

        @Override
        String lineString() {
            return this.name + "=" + this.value;
        }

        @Override
        PropertyLine withOverrides(List<String> list) {
            return new Property(this.name, this.value, this.pos, this.scope, list);
        }
    }

    private static class Scope
    extends ConfigLine {
        String expr;
        boolean matches;

        Scope(String string, int n, boolean bl) {
            this.expr = string;
            this.pos = n;
            this.matches = bl;
        }

        @Override
        String getLine() {
            return "# scope: " + this.expr + " [" + this.matches + "]";
        }

        @Override
        Scope getScope() {
            return this;
        }
    }

    private static class PropertyLine
    extends ConfigLine {
        String name;
        String value;
        List<String> overrides;

        PropertyLine() {
            this.isProperty = true;
        }

        String lineString() {
            throw new UnsupportedOperationException();
        }

        PropertyLine withOverrides(List<String> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        String getLine() {
            if (this.overrides == null || this.overrides.size() == 0) {
                return this.lineString();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = this.overrides.size(); i > 0; --i) {
                arrayList.add(this.overrides.get(i - 1));
            }
            return ConfigFile.mkCommentString(arrayList, "overrides", "\n" + this.lineString());
        }
    }

    private static class ConfigLine {
        String line;
        int pos;
        Scope scope;
        boolean isProperty = false;

        private ConfigLine() {
        }

        String getLine() {
            return this.line;
        }

        int getPos() {
            return this.pos;
        }

        Scope getScope() {
            return this.scope;
        }
    }
}

