/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.basic;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import org.junit.Assert;
import org.junit.Test;

public class CommandUsingRequestCache
extends HystrixCommand<Boolean> {
    private final int value;

    protected CommandUsingRequestCache(int value) {
        super(HystrixCommandGroupKey.Factory.asKey((String)"ExampleGroup"));
        this.value = value;
    }

    protected Boolean run() {
        return this.value == 0 || this.value % 2 == 0;
    }

    protected String getCacheKey() {
        return String.valueOf(this.value);
    }

    public static class UnitTest {
        @Test
        public void testWithoutCacheHits() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                Assert.assertTrue((boolean)((Boolean)new CommandUsingRequestCache(2).execute()));
                Assert.assertFalse((boolean)((Boolean)new CommandUsingRequestCache(1).execute()));
                Assert.assertTrue((boolean)((Boolean)new CommandUsingRequestCache(0).execute()));
                Assert.assertTrue((boolean)((Boolean)new CommandUsingRequestCache(58672).execute()));
            }
            finally {
                context.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void testWithCacheHits() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                CommandUsingRequestCache command2a = new CommandUsingRequestCache(2);
                CommandUsingRequestCache command2b = new CommandUsingRequestCache(2);
                Assert.assertTrue((boolean)((Boolean)command2a.execute()));
                Assert.assertFalse((boolean)command2a.isResponseFromCache());
                Assert.assertTrue((boolean)((Boolean)command2b.execute()));
                Assert.assertTrue((boolean)command2b.isResponseFromCache());
            }
            finally {
                context.shutdown();
            }
            context = HystrixRequestContext.initializeContext();
            try {
                CommandUsingRequestCache command3b = new CommandUsingRequestCache(2);
                Assert.assertTrue((boolean)((Boolean)command3b.execute()));
                Assert.assertFalse((boolean)command3b.isResponseFromCache());
            }
            finally {
                context.shutdown();
            }
        }
    }
}

