/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.basic;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import org.junit.Assert;
import org.junit.Test;

public class CommandFacadeWithPrimarySecondary
extends HystrixCommand<String> {
    private static final DynamicBooleanProperty usePrimary = DynamicPropertyFactory.getInstance().getBooleanProperty("primarySecondary.usePrimary", true);
    private final int id;

    public CommandFacadeWithPrimarySecondary(int id) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"SystemX")).andCommandKey(HystrixCommandKey.Factory.asKey((String)"PrimarySecondaryCommand")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE)));
        this.id = id;
    }

    protected String run() {
        if (usePrimary.get()) {
            return (String)new PrimaryCommand(this.id).execute();
        }
        return (String)new SecondaryCommand(this.id).execute();
    }

    protected String getFallback() {
        return "static-fallback-" + this.id;
    }

    protected String getCacheKey() {
        return String.valueOf(this.id);
    }

    public static class UnitTest {
        @Test
        public void testPrimary() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                ConfigurationManager.getConfigInstance().setProperty("primarySecondary.usePrimary", (Object)true);
                Assert.assertEquals((Object)"responseFromPrimary-20", (Object)new CommandFacadeWithPrimarySecondary(20).execute());
            }
            finally {
                context.shutdown();
                ConfigurationManager.getConfigInstance().clear();
            }
        }

        @Test
        public void testSecondary() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                ConfigurationManager.getConfigInstance().setProperty("primarySecondary.usePrimary", (Object)false);
                Assert.assertEquals((Object)"responseFromSecondary-20", (Object)new CommandFacadeWithPrimarySecondary(20).execute());
            }
            finally {
                context.shutdown();
                ConfigurationManager.getConfigInstance().clear();
            }
        }
    }

    private static class SecondaryCommand
    extends HystrixCommand<String> {
        private final int id;

        private SecondaryCommand(int id) {
            super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"SystemX")).andCommandKey(HystrixCommandKey.Factory.asKey((String)"SecondaryCommand")).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)"SecondaryCommand")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(100)));
            this.id = id;
        }

        protected String run() {
            return "responseFromSecondary-" + this.id;
        }
    }

    private static class PrimaryCommand
    extends HystrixCommand<String> {
        private final int id;

        private PrimaryCommand(int id) {
            super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"SystemX")).andCommandKey(HystrixCommandKey.Factory.asKey((String)"PrimaryCommand")).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)"PrimaryCommand")).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(600)));
            this.id = id;
        }

        protected String run() {
            return "responseFromPrimary-" + this.id;
        }
    }
}

