/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.basic;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import rx.Observable;
import rx.Observer;
import rx.functions.Action1;

public class CommandHelloWorld
extends HystrixCommand<String> {
    private final String name;

    public CommandHelloWorld(String name) {
        super(HystrixCommandGroupKey.Factory.asKey((String)"ExampleGroup"));
        this.name = name;
    }

    protected String run() {
        return "Hello " + this.name + "!";
    }

    public static class UnitTest {
        @Test
        public void testSynchronous() {
            Assert.assertEquals((Object)"Hello World!", (Object)new CommandHelloWorld("World").execute());
            Assert.assertEquals((Object)"Hello Bob!", (Object)new CommandHelloWorld("Bob").execute());
        }

        @Test
        public void testAsynchronous1() throws Exception {
            Assert.assertEquals((Object)"Hello World!", new CommandHelloWorld("World").queue().get());
            Assert.assertEquals((Object)"Hello Bob!", new CommandHelloWorld("Bob").queue().get());
        }

        @Test
        public void testAsynchronous2() throws Exception {
            Future fWorld = new CommandHelloWorld("World").queue();
            Future fBob = new CommandHelloWorld("Bob").queue();
            Assert.assertEquals((Object)"Hello World!", fWorld.get());
            Assert.assertEquals((Object)"Hello Bob!", fBob.get());
        }

        @Test
        public void testObservable() throws Exception {
            Observable fWorld = new CommandHelloWorld("World").observe();
            Observable fBob = new CommandHelloWorld("Bob").observe();
            Assert.assertEquals((Object)"Hello World!", (Object)fWorld.toBlocking().single());
            Assert.assertEquals((Object)"Hello Bob!", (Object)fBob.toBlocking().single());
            fWorld.subscribe((Observer)new Observer<String>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    e.printStackTrace();
                }

                public void onNext(String v) {
                    System.out.println("onNext: " + v);
                }
            });
            fBob.subscribe((Action1)new Action1<String>(){

                public void call(String v) {
                    System.out.println("onNext: " + v);
                }
            });
        }
    }
}

