/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.basic;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CommandThatFailsSilently
extends HystrixCommand<List<String>> {
    private final boolean throwException;

    public CommandThatFailsSilently(boolean throwException) {
        super(HystrixCommandGroupKey.Factory.asKey((String)"ExampleGroup"));
        this.throwException = throwException;
    }

    protected List<String> run() {
        if (this.throwException) {
            throw new RuntimeException("failure from CommandThatFailsFast");
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add("success");
        return values;
    }

    protected List<String> getFallback() {
        return Collections.emptyList();
    }

    public static class UnitTest {
        @Test
        public void testSuccess() {
            Assert.assertEquals((Object)"success", ((List)new CommandThatFailsSilently(false).execute()).get(0));
        }

        @Test
        public void testFailure() {
            try {
                Assert.assertEquals((long)0L, (long)((List)new CommandThatFailsSilently(true).execute()).size());
            }
            catch (HystrixRuntimeException e) {
                Assert.fail((String)"we should not get an exception as we fail silently with a fallback");
            }
        }
    }
}

