/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.demo;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.examples.demo.UserAccount;
import java.net.HttpCookie;

public class GetUserAccountCommand
extends HystrixCommand<UserAccount> {
    private final HttpCookie httpCookie;
    private final UserCookie userCookie;

    public GetUserAccountCommand(HttpCookie cookie) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"User")));
        this.httpCookie = cookie;
        this.userCookie = UserCookie.parseCookie(this.httpCookie);
    }

    protected UserAccount run() {
        try {
            Thread.sleep((int)(Math.random() * 10.0) + 2);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (Math.random() > 0.95) {
            throw new RuntimeException("random failure processing UserAccount network response");
        }
        if (Math.random() > 0.95) {
            try {
                Thread.sleep((int)(Math.random() * 300.0) + 25);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return new UserAccount(86975, "John James", 2, true, false, true);
    }

    protected String getCacheKey() {
        return this.httpCookie.getValue();
    }

    protected UserAccount getFallback() {
        return new UserAccount(this.userCookie.userId, this.userCookie.name, this.userCookie.accountType, true, true, true);
    }

    private static class UserCookie {
        private final int userId;
        private final String name;
        private final int accountType;

        private static UserCookie parseCookie(HttpCookie cookie) {
            if (Math.random() < 0.998) {
                return new UserCookie(12345, "Henry Peter", 1);
            }
            throw new IllegalArgumentException();
        }

        public UserCookie(int userId, String name, int accountType) {
            this.userId = userId;
            this.name = name;
            this.accountType = accountType;
        }
    }
}

