/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.examples.basic;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import org.junit.Assert;
import org.junit.Test;

public class CommandUsingRequestCacheInvalidation {
    private static volatile String prefixStoredOnRemoteDataStore = "ValueBeforeSet_";

    public static class UnitTest {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void getGetSetGet() {
            HystrixRequestContext context = HystrixRequestContext.initializeContext();
            try {
                Assert.assertEquals((Object)"ValueBeforeSet_1", (Object)new GetterCommand(1).execute());
                GetterCommand commandAgainstCache = new GetterCommand(1);
                Assert.assertEquals((Object)"ValueBeforeSet_1", (Object)commandAgainstCache.execute());
                Assert.assertTrue((boolean)commandAgainstCache.isResponseFromCache());
                new SetterCommand(1, "ValueAfterSet_").execute();
                GetterCommand commandAfterSet = new GetterCommand(1);
                Assert.assertFalse((boolean)commandAfterSet.isResponseFromCache());
                Assert.assertEquals((Object)"ValueAfterSet_1", (Object)commandAfterSet.execute());
            }
            finally {
                context.shutdown();
            }
        }
    }

    public static class SetterCommand
    extends HystrixCommand<Void> {
        private final int id;
        private final String prefix;

        public SetterCommand(int id, String prefix) {
            super(HystrixCommandGroupKey.Factory.asKey((String)"GetSetGet"));
            this.id = id;
            this.prefix = prefix;
        }

        protected Void run() {
            prefixStoredOnRemoteDataStore = this.prefix;
            GetterCommand.flushCache(this.id);
            return null;
        }
    }

    public static class GetterCommand
    extends HystrixCommand<String> {
        private static final HystrixCommandKey GETTER_KEY = HystrixCommandKey.Factory.asKey((String)"GetterCommand");
        private final int id;

        public GetterCommand(int id) {
            super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"GetSetGet")).andCommandKey(GETTER_KEY));
            this.id = id;
        }

        protected String run() {
            return prefixStoredOnRemoteDataStore + this.id;
        }

        protected String getCacheKey() {
            return String.valueOf(this.id);
        }

        public static void flushCache(int id) {
            HystrixRequestCache.getInstance((HystrixCommandKey)GETTER_KEY, (HystrixConcurrencyStrategy)HystrixConcurrencyStrategyDefault.getInstance()).clear(String.valueOf(id));
        }
    }
}

