/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.test.consumer;

import com.netflix.hollow.api.consumer.HollowConsumer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TestBlobRetriever
implements HollowConsumer.BlobRetriever {
    private final Map<Long, HollowConsumer.Blob> snapshots = new HashMap<Long, HollowConsumer.Blob>();
    private final Map<Long, HollowConsumer.Blob> deltas = new HashMap<Long, HollowConsumer.Blob>();
    private final Map<Long, HollowConsumer.Blob> reverseDeltas = new HashMap<Long, HollowConsumer.Blob>();
    private final Map<Long, HollowConsumer.HeaderBlob> headers = new HashMap<Long, HollowConsumer.HeaderBlob>();

    public HollowConsumer.HeaderBlob retrieveHeaderBlob(long desiredVersion) {
        return this.headers.get(desiredVersion);
    }

    public HollowConsumer.Blob retrieveSnapshotBlob(long desiredVersion) {
        HollowConsumer.Blob b = this.snapshots.get(desiredVersion);
        this.resetStream(b);
        return b;
    }

    public HollowConsumer.Blob retrieveDeltaBlob(long currentVersion) {
        HollowConsumer.Blob b = this.deltas.get(currentVersion);
        this.resetStream(b);
        return b;
    }

    public HollowConsumer.Blob retrieveReverseDeltaBlob(long currentVersion) {
        HollowConsumer.Blob b = this.reverseDeltas.get(currentVersion);
        this.resetStream(b);
        return b;
    }

    private void resetStream(HollowConsumer.Blob b) {
        try {
            if (b != null && b.getInputStream() != null) {
                b.getInputStream().reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get and reset stream", e);
        }
    }

    public void addSnapshot(long desiredVersion, HollowConsumer.Blob transition) {
        this.snapshots.put(desiredVersion, transition);
    }

    public void addDelta(long currentVersion, HollowConsumer.Blob transition) {
        this.deltas.put(currentVersion, transition);
    }

    public void addReverseDelta(long currentVersion, HollowConsumer.Blob transition) {
        this.reverseDeltas.put(currentVersion, transition);
    }

    public void addHeader(long desiredVersion, HollowConsumer.HeaderBlob headerBlob) {
        this.headers.put(desiredVersion, headerBlob);
    }
}

