/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter;

import com.fasterxml.jackson.core.JsonParser;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecord;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordWriter;
import com.netflix.hollow.core.write.objectmapper.flatrecords.HollowSchemaIdentifierMapper;
import com.netflix.hollow.jsonadapter.AbstractHollowJsonAdaptorTask;
import com.netflix.hollow.jsonadapter.HollowJsonAdapter;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Consumer;

public class HollowJsonToFlatRecordTask
extends AbstractHollowJsonAdaptorTask {
    private final HollowJsonAdapter adapter;
    private final HollowSchemaIdentifierMapper schemaIdMapper;
    private final Consumer<FlatRecord> action;
    private final ThreadLocal<FlatRecordWriter> flatRecordWriter;

    public HollowJsonToFlatRecordTask(HollowJsonAdapter adapter, HollowSchemaIdentifierMapper schemaIdMapper, Consumer<FlatRecord> action) {
        super(adapter.getTypeName());
        this.adapter = adapter;
        this.schemaIdMapper = schemaIdMapper;
        this.flatRecordWriter = new ThreadLocal();
        this.action = action;
    }

    public void process(Reader jsonReader) throws Exception {
        this.processFile(jsonReader, Integer.MAX_VALUE);
    }

    @Override
    protected int processRecord(JsonParser parser) throws IOException {
        FlatRecordWriter recWriter = this.getFlatRecordWriter();
        int ordinal = this.adapter.processRecord(parser, recWriter);
        FlatRecord rec = recWriter.generateFlatRecord();
        this.action.accept(rec);
        return ordinal;
    }

    private FlatRecordWriter getFlatRecordWriter() {
        FlatRecordWriter writer = this.flatRecordWriter.get();
        if (writer == null) {
            writer = new FlatRecordWriter((HollowDataset)this.adapter.stateEngine, this.schemaIdMapper);
            this.flatRecordWriter.set(writer);
        }
        writer.reset();
        return writer;
    }
}

