/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter;

import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.HollowObjectTypeWriteState;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordWriter;
import com.netflix.hollow.jsonadapter.HollowJsonAdapter;
import com.netflix.hollow.jsonadapter.ObjectMappedFieldPath;
import com.netflix.hollow.jsonadapter.field.FieldProcessor;
import java.util.HashMap;
import java.util.Map;

public class ObjectFieldMapping {
    private final HollowWriteStateEngine stateEngine;
    private final String typeName;
    private final HollowJsonAdapter populator;
    private final Map<String, ObjectMappedFieldPath> mappedFieldPaths;
    private final RemappingBuilderInstruction rootInstruction;
    private final Map<String, HollowObjectWriteRecord> writeRecords;

    public ObjectFieldMapping(String typeName, HollowJsonAdapter populator) {
        this.stateEngine = populator.stateEngine;
        this.typeName = typeName;
        this.populator = populator;
        HollowObjectTypeWriteState typeState = (HollowObjectTypeWriteState)this.stateEngine.getTypeState(typeName);
        HollowObjectWriteRecord writeRec = new HollowObjectWriteRecord(typeState.getSchema());
        this.rootInstruction = new RemappingBuilderInstruction(writeRec, typeState);
        this.mappedFieldPaths = new HashMap<String, ObjectMappedFieldPath>();
        this.writeRecords = new HashMap<String, HollowObjectWriteRecord>();
        this.mapAllPaths((HollowObjectSchema)this.stateEngine.getSchema(typeName));
    }

    private ObjectFieldMapping(String typeName, HollowJsonAdapter populator, Map<String, ObjectMappedFieldPath> mappedFieldPaths, RemappingBuilderInstruction rootInstruction, Map<String, HollowObjectWriteRecord> writeRecords) {
        this.stateEngine = populator.stateEngine;
        this.typeName = typeName;
        this.populator = populator;
        this.rootInstruction = rootInstruction;
        this.mappedFieldPaths = mappedFieldPaths;
        this.writeRecords = writeRecords;
    }

    public int build(int passthroughOrdinal, FlatRecordWriter flatRecordWriter) {
        int ordinal = this.rootInstruction.executeInstruction(passthroughOrdinal, flatRecordWriter);
        for (Map.Entry<String, HollowObjectWriteRecord> entry : this.writeRecords.entrySet()) {
            entry.getValue().reset();
        }
        return ordinal;
    }

    private void mapAllPaths(HollowObjectSchema schema) {
        for (int i = 0; i < schema.numFields(); ++i) {
            if (this.mappedFieldPaths.containsKey(schema.getFieldName(i))) continue;
            HollowObjectWriteRecord rec = this.getWriteRecord(schema);
            this.mappedFieldPaths.put(schema.getFieldName(i), new ObjectMappedFieldPath(rec, schema.getFieldName(i), schema.getName(), schema.getFieldName(i), i, this.populator.getFieldProcessor(schema.getName(), schema.getFieldName(i))));
        }
    }

    public void addRemappedPath(String fromFieldName, String ... fieldPaths) {
        ObjectMappedFieldPath pathMapping = this.addPathMapping(fromFieldName, fieldPaths, this.rootInstruction, 0);
        this.mappedFieldPaths.put(fromFieldName, pathMapping);
    }

    public ObjectMappedFieldPath getSingleFieldMapping() {
        return this.mappedFieldPaths.entrySet().iterator().next().getValue();
    }

    public ObjectMappedFieldPath getMappedFieldPath(String fieldName) {
        return this.mappedFieldPaths.get(fieldName);
    }

    public void addFieldProcessor(FieldProcessor fieldProcessor) {
        for (Map.Entry<String, ObjectMappedFieldPath> entry : this.mappedFieldPaths.entrySet()) {
            if (fieldProcessor.getEntityName().equals(entry.getValue().getTypeName()) && fieldProcessor.getFieldName().equals(entry.getValue().getFieldName())) {
                entry.getValue().setFieldProcessor(fieldProcessor);
                return;
            }
            if (!fieldProcessor.getEntityName().equals(entry.getValue().getUnmappedTypeName()) || !fieldProcessor.getFieldName().equals(entry.getValue().getUnmappedFieldName())) continue;
            entry.getValue().setFieldProcessor(fieldProcessor);
            return;
        }
    }

    private ObjectMappedFieldPath addPathMapping(String fieldName, String[] fieldPaths, RemappingBuilderInstruction instruction, int idx) {
        if (idx < fieldPaths.length - 1) {
            RemappingBuilderInstruction childInstruction = (RemappingBuilderInstruction)instruction.childrenRecs.get(fieldPaths[idx]);
            HollowObjectSchema schema = instruction.typeState.getSchema();
            String referencedType = schema.getReferencedType(fieldPaths[idx]);
            if (childInstruction == null) {
                HollowObjectTypeWriteState childTypeState = (HollowObjectTypeWriteState)this.stateEngine.getTypeState(referencedType);
                HollowObjectWriteRecord childWriteRec = this.getWriteRecord(childTypeState.getSchema());
                childInstruction = new RemappingBuilderInstruction(childWriteRec, childTypeState);
                instruction.addChildInstruction(fieldPaths[idx], childInstruction);
            }
            return this.addPathMapping(fieldName, fieldPaths, childInstruction, idx + 1);
        }
        HollowObjectSchema schema = instruction.rec.getSchema();
        String remappedFieldName = fieldPaths[idx];
        return new ObjectMappedFieldPath(instruction.rec, remappedFieldName, this.typeName, fieldName, schema.getPosition(remappedFieldName), this.findFieldProcessor(this.typeName, fieldName, schema.getName(), remappedFieldName));
    }

    private FieldProcessor findFieldProcessor(String typeName, String fieldName, String mappedTypeName, String mappedFieldName) {
        FieldProcessor fp = this.populator.getFieldProcessor(typeName, fieldName);
        if (fp != null) {
            return fp;
        }
        return this.populator.getFieldProcessor(mappedTypeName, mappedFieldName);
    }

    private HollowObjectWriteRecord getWriteRecord(HollowObjectSchema schema) {
        HollowObjectWriteRecord writeRecord = this.writeRecords.get(schema.getName());
        if (writeRecord == null) {
            writeRecord = new HollowObjectWriteRecord(schema);
            this.writeRecords.put(schema.getName(), writeRecord);
        }
        return writeRecord;
    }

    public ObjectFieldMapping clone() {
        HashMap<String, HollowObjectWriteRecord> clonedWriteRecords = new HashMap<String, HollowObjectWriteRecord>();
        for (Map.Entry<String, HollowObjectWriteRecord> recEntry : this.writeRecords.entrySet()) {
            clonedWriteRecords.put(recEntry.getKey(), new HollowObjectWriteRecord(recEntry.getValue().getSchema()));
        }
        HashMap<String, ObjectMappedFieldPath> clonedMappedFieldPaths = new HashMap<String, ObjectMappedFieldPath>();
        for (Map.Entry<String, ObjectMappedFieldPath> fieldEntry : this.mappedFieldPaths.entrySet()) {
            ObjectMappedFieldPath original = fieldEntry.getValue();
            HollowObjectWriteRecord clonedWriteRecord = (HollowObjectWriteRecord)clonedWriteRecords.get(original.getWriteRecord().getSchema().getName());
            clonedMappedFieldPaths.put(fieldEntry.getKey(), new ObjectMappedFieldPath(clonedWriteRecord, original.getFieldName(), original.getUnmappedTypeName(), original.getUnmappedFieldName(), original.getFieldPosition(), original.getFieldProcessor()));
        }
        return new ObjectFieldMapping(this.typeName, this.populator, clonedMappedFieldPaths, this.rootInstruction.clone(clonedWriteRecords), clonedWriteRecords);
    }

    private class RemappingBuilderInstruction {
        private final HollowObjectWriteRecord rec;
        private final HollowObjectTypeWriteState typeState;
        private final Map<String, RemappingBuilderInstruction> childrenRecs;

        public RemappingBuilderInstruction(HollowObjectWriteRecord rec, HollowObjectTypeWriteState typeState) {
            this(rec, typeState, new HashMap<String, RemappingBuilderInstruction>());
        }

        private RemappingBuilderInstruction(HollowObjectWriteRecord rec, HollowObjectTypeWriteState typeState, Map<String, RemappingBuilderInstruction> childrenRecs) {
            this.rec = rec;
            this.typeState = typeState;
            this.childrenRecs = childrenRecs;
        }

        public void addChildInstruction(String fieldName, RemappingBuilderInstruction instruction) {
            this.childrenRecs.put(fieldName, instruction);
        }

        public int executeInstruction(int passthroughOrdinal, FlatRecordWriter flatRecordWriter) {
            for (Map.Entry<String, RemappingBuilderInstruction> childEntry : this.childrenRecs.entrySet()) {
                int childOrdinal = childEntry.getValue().executeInstruction(-1, flatRecordWriter);
                this.rec.setReference(childEntry.getKey(), childOrdinal);
            }
            if (passthroughOrdinal != -1) {
                this.rec.setReference("passthrough", passthroughOrdinal);
            }
            if (flatRecordWriter != null) {
                return flatRecordWriter.write((HollowSchema)this.typeState.getSchema(), (HollowWriteRecord)this.rec);
            }
            return this.typeState.add((HollowWriteRecord)this.rec);
        }

        public RemappingBuilderInstruction clone(Map<String, HollowObjectWriteRecord> clonedWriteRecords) {
            HashMap<String, RemappingBuilderInstruction> childClones = new HashMap<String, RemappingBuilderInstruction>();
            for (Map.Entry<String, RemappingBuilderInstruction> childEntry : this.childrenRecs.entrySet()) {
                childClones.put(childEntry.getKey(), childEntry.getValue().clone(clonedWriteRecords));
            }
            HollowObjectWriteRecord clonedRec = clonedWriteRecords.get(this.rec.getSchema().getName());
            return new RemappingBuilderInstruction(clonedRec, this.typeState, childClones);
        }
    }
}

