/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter.chunker;

import com.netflix.hollow.jsonadapter.chunker.JsonArrayChunkReader;
import com.netflix.hollow.jsonadapter.chunker.JsonArrayChunkerInputSegment;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;

public class JsonArrayChunker {
    private static final int DEFAULT_SEGMENT_LENGTH = 262144;
    private static final int SEGMENT_QUEUE_SIZE = 32;
    private final Reader reader;
    private final Queue<CompletableFuture<JsonArrayChunkerInputSegment>> bufferSegments;
    private final Executor executor;
    private final int segmentLength;
    private JsonArrayChunkerInputSegment currentSegment;
    private long currentSegmentStartOffset;
    private boolean eofReached;

    public JsonArrayChunker(Reader reader, Executor executor) {
        this(reader, executor, 262144);
    }

    JsonArrayChunker(Reader reader, Executor executor, int segmentLength) {
        this.reader = reader;
        this.bufferSegments = new ArrayDeque<CompletableFuture<JsonArrayChunkerInputSegment>>();
        this.executor = executor;
        this.segmentLength = segmentLength;
    }

    public void initialize() throws IOException {
        while (!this.eofReached && this.bufferSegments.size() < 32) {
            this.fillOneSegment();
        }
        this.nextSegment();
    }

    public Reader nextChunk() throws IOException {
        while (!this.currentSegment.nextSpecialCharacter()) {
            if (this.nextSegment()) continue;
            return null;
        }
        if (this.currentSegment.specialCharacter() != '{') {
            throw new IllegalStateException("Bad json");
        }
        int nestedObjectCount = 1;
        JsonArrayChunkReader chunkReader = new JsonArrayChunkReader(this.currentSegment, this.currentSegment.specialCharacterIteratorPosition());
        boolean insideQuotes = false;
        long lastEscapeCharacterLocation = Long.MIN_VALUE;
        while (nestedObjectCount > 0) {
            while (!this.currentSegment.nextSpecialCharacter()) {
                if (!this.nextSegment()) {
                    throw new IllegalStateException("Bad json");
                }
                chunkReader.addSegment(this.currentSegment);
            }
            switch (this.currentSegment.specialCharacter()) {
                case '{': {
                    if (insideQuotes) break;
                    ++nestedObjectCount;
                    break;
                }
                case '}': {
                    if (insideQuotes) break;
                    --nestedObjectCount;
                    break;
                }
                case '\"': {
                    long currentLocation = this.currentSegmentStartOffset + (long)this.currentSegment.specialCharacterIteratorPosition();
                    if (lastEscapeCharacterLocation == currentLocation - 1L) break;
                    insideQuotes = !insideQuotes;
                    break;
                }
                case '\\': {
                    long currentLocation = this.currentSegmentStartOffset + (long)this.currentSegment.specialCharacterIteratorPosition();
                    if (lastEscapeCharacterLocation == currentLocation - 1L) break;
                    lastEscapeCharacterLocation = currentLocation;
                }
            }
        }
        chunkReader.setEndOffset(this.currentSegment.specialCharacterIteratorPosition() + 1);
        return chunkReader;
    }

    private boolean nextSegment() throws IOException {
        if (this.bufferSegments.isEmpty()) {
            return false;
        }
        if (!this.eofReached) {
            this.fillOneSegment();
        }
        this.currentSegmentStartOffset += (long)this.segmentLength;
        try {
            this.currentSegment = this.bufferSegments.remove().join();
        }
        catch (CompletionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw t instanceof RuntimeException ? (RuntimeException)t : e;
        }
        return true;
    }

    private void fillOneSegment() throws IOException {
        JsonArrayChunkerInputSegment seg = new JsonArrayChunkerInputSegment(this.segmentLength);
        this.eofReached = seg.fill(this.reader);
        this.bufferSegments.add(CompletableFuture.supplyAsync(seg::findSpecialCharacterOffsets, this.executor));
    }
}

