/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter.chunker;

import com.netflix.hollow.core.util.IntList;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

public class JsonArrayChunkerInputSegment {
    private final char[] data;
    private final IntList specialCharacterOffsets;
    private int dataLength;
    private int specialCharacterIteratorPos = -1;
    private volatile boolean offsetsDefined = false;

    public JsonArrayChunkerInputSegment(int len) {
        this.data = new char[len];
        this.specialCharacterOffsets = new IntList();
    }

    public boolean fill(Reader reader) throws IOException {
        this.dataLength = IOUtils.read((Reader)reader, (char[])this.data);
        return this.dataLength < this.data.length;
    }

    public synchronized void findSpecialCharacterOffsets() {
        block6: for (int i = 0; i < this.data.length; ++i) {
            switch (this.data[i]) {
                case '{': {
                    this.specialCharacterOffsets.add(i);
                    continue block6;
                }
                case '}': {
                    this.specialCharacterOffsets.add(i | 0x40000000);
                    continue block6;
                }
                case '\"': {
                    this.specialCharacterOffsets.add(i | Integer.MIN_VALUE);
                    continue block6;
                }
                case '\\': {
                    this.specialCharacterOffsets.add(i | 0xC0000000);
                    continue block6;
                }
            }
        }
        this.offsetsDefined = true;
        this.notify();
    }

    public synchronized void waitForDefinedOffsets() throws InterruptedException {
        while (!this.offsetsDefined) {
            this.wait();
        }
    }

    public boolean nextSpecialCharacter() {
        return ++this.specialCharacterIteratorPos < this.specialCharacterOffsets.size();
    }

    public int specialCharacterIteratorPosition() {
        return this.specialCharacterOffsets.get(this.specialCharacterIteratorPos) & 0x3FFFFFFF;
    }

    public char specialCharacter() {
        switch (this.specialCharacterOffsets.get(this.specialCharacterIteratorPos) >>> 30) {
            case 0: {
                return '{';
            }
            case 1: {
                return '}';
            }
            case 2: {
                return '\"';
            }
            case 3: {
                return '\\';
            }
        }
        throw new IllegalStateException();
    }

    public int length() {
        return this.dataLength;
    }

    public char charAt(int offset) {
        return this.data[offset];
    }

    public int copyTo(char[] dest, int srcPos, int destPos, int len, int maxSrcPos) {
        int bytesAvailable = maxSrcPos - srcPos;
        if (bytesAvailable >= len) {
            System.arraycopy(this.data, srcPos, dest, destPos, len);
            return len;
        }
        System.arraycopy(this.data, srcPos, dest, destPos, bytesAvailable);
        return bytesAvailable;
    }
}

