/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter.discover;

import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.jsonadapter.discover.DiscoveredSchemaType;
import com.netflix.hollow.jsonadapter.discover.HollowDiscoveredField;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HollowDiscoveredSchema {
    final String schemaName;
    final DiscoveredSchemaType type;
    final String subType;
    final Map<String, HollowDiscoveredField> fields;

    public HollowDiscoveredSchema(String schemaName, DiscoveredSchemaType schemaType, String subType) {
        this.schemaName = schemaName;
        this.type = schemaType;
        this.subType = subType;
        this.fields = schemaType == DiscoveredSchemaType.OBJECT ? new ConcurrentHashMap() : Collections.emptyMap();
    }

    public String getName() {
        return this.schemaName;
    }

    public Map<String, HollowDiscoveredField> getFields() {
        return this.fields;
    }

    public synchronized void addOrReplaceField(String fieldName, HollowObjectSchema.FieldType fieldType) {
        this.fields.put(fieldName, new HollowDiscoveredField(fieldType, null));
    }

    public void addField(String fieldName, HollowObjectSchema.FieldType fieldType) {
        this.addField(fieldName, fieldType, null);
    }

    public synchronized void addField(String fieldName, HollowObjectSchema.FieldType fieldType, String referencedType) {
        HollowDiscoveredField field = this.fields.get(fieldName);
        if (field == null) {
            this.fields.put(fieldName, new HollowDiscoveredField(fieldType, referencedType));
        } else if (field.fieldType != fieldType) {
            field.fieldType = HollowDiscoveredSchema.mostRelaxed(field.fieldType, fieldType);
        } else if (field.referencedType != referencedType) {
            throw new RuntimeException("Cannot reference more than one type of object for a given field");
        }
    }

    private static HollowObjectSchema.FieldType mostRelaxed(HollowObjectSchema.FieldType ft1, HollowObjectSchema.FieldType ft2) {
        if (ft1 == HollowObjectSchema.FieldType.STRING || ft2 == HollowObjectSchema.FieldType.STRING) {
            return HollowObjectSchema.FieldType.STRING;
        }
        if (ft1 == HollowObjectSchema.FieldType.DOUBLE || ft2 == HollowObjectSchema.FieldType.DOUBLE) {
            return HollowObjectSchema.FieldType.DOUBLE;
        }
        throw new RuntimeException("There is no compatible field type between " + ft1 + " and " + ft2);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HollowDiscoveredSchema [schemaName=");
        builder.append(this.schemaName);
        builder.append(", type=");
        builder.append((Object)this.type);
        builder.append(", subType=");
        builder.append(this.subType);
        builder.append(", fields=");
        builder.append(this.fields);
        builder.append("]");
        return builder.toString();
    }

    public HollowSchema toHollowSchema() {
        switch (this.type) {
            case LIST: {
                return new HollowListSchema(this.schemaName, this.subType);
            }
            case MAP: {
                return new HollowMapSchema(this.schemaName, "MapKey", this.subType, new String[0]);
            }
            case OBJECT: {
                HollowObjectSchema schema = new HollowObjectSchema(this.schemaName, this.fields.size(), new String[0]);
                for (Map.Entry<String, HollowDiscoveredField> entry : this.fields.entrySet()) {
                    if (entry.getValue().fieldType == HollowObjectSchema.FieldType.STRING) {
                        schema.addField(entry.getKey(), HollowObjectSchema.FieldType.REFERENCE, "String");
                        continue;
                    }
                    schema.addField(entry.getKey(), entry.getValue().fieldType, entry.getValue().referencedType);
                }
                return schema;
            }
        }
        throw new IllegalStateException("HollowDiscoveredSchema type must be one of LIST,MAP,OBJECT.  Was " + (Object)((Object)this.type));
    }
}

