/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter.chunker;

import com.netflix.hollow.jsonadapter.chunker.JsonArrayChunkerInputSegment;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class JsonArrayChunkReader
extends Reader {
    private final List<JsonArrayChunkerInputSegment> segments = new ArrayList<JsonArrayChunkerInputSegment>(2);
    private int lastSegmentEndPos;
    private int currentSegment;
    private int currentSegmentOffset;

    public JsonArrayChunkReader(JsonArrayChunkerInputSegment firstSegment, int startOffset) {
        this.segments.add(firstSegment);
        this.currentSegment = 0;
        this.currentSegmentOffset = startOffset;
    }

    public void addSegment(JsonArrayChunkerInputSegment segment) {
        this.segments.add(segment);
    }

    public void setEndOffset(int endOffset) {
        this.lastSegmentEndPos = endOffset;
    }

    @Override
    public int read() {
        while (this.currentSegment < this.segments.size()) {
            int maxSrcPos;
            int n = maxSrcPos = this.currentSegment == this.segments.size() - 1 ? this.lastSegmentEndPos : this.segments.get(this.currentSegment).length();
            if (this.currentSegmentOffset < maxSrcPos) {
                return this.segments.get(this.currentSegment).charAt(this.currentSegmentOffset++);
            }
            ++this.currentSegment;
            this.currentSegmentOffset = 0;
        }
        return -1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.currentSegment == this.segments.size()) {
            return -1;
        }
        int totalCopiedBytes = 0;
        while (this.currentSegment < this.segments.size()) {
            int maxSrcPos = this.currentSegment == this.segments.size() - 1 ? this.lastSegmentEndPos : this.segments.get(this.currentSegment).length();
            int copiedBytes = this.segments.get(this.currentSegment).copyTo(cbuf, this.currentSegmentOffset, off, len, maxSrcPos);
            totalCopiedBytes += copiedBytes;
            this.currentSegmentOffset += copiedBytes;
            if ((len -= copiedBytes) == 0) {
                return totalCopiedBytes;
            }
            off += copiedBytes;
            ++this.currentSegment;
            this.currentSegmentOffset = 0;
        }
        return totalCopiedBytes;
    }

    @Override
    public void close() {
    }
}

