/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter.discover;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.jsonadapter.AbstractHollowJsonAdaptorTask;
import com.netflix.hollow.jsonadapter.discover.DiscoveredSchemaType;
import com.netflix.hollow.jsonadapter.discover.HollowDiscoveredSchema;
import com.netflix.hollow.jsonadapter.discover.HollowSchemaNamer;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HollowJsonAdapterSchemaDiscoverer
extends AbstractHollowJsonAdaptorTask {
    private final Set<String> mapTypes = new HashSet<String>();
    private final Map<String, HollowDiscoveredSchema> discoveredSchemas = new ConcurrentHashMap<String, HollowDiscoveredSchema>();
    private final HollowSchemaNamer schemaNamer = new HollowSchemaNamer();

    public HollowJsonAdapterSchemaDiscoverer(String typeName) {
        super(typeName, "scan");
    }

    public void addMapTypes(String ... types) {
        for (String type : types) {
            String mapType = this.schemaNamer.schemaNameFromPropertyPath(type);
            this.mapTypes.add(mapType);
        }
    }

    public void addMapTypes(Set<String> types) {
        for (String type : types) {
            String mapType = this.schemaNamer.schemaNameFromPropertyPath(type);
            this.mapTypes.add(mapType);
        }
    }

    @Override
    protected int processRecord(JsonParser parser) throws IOException {
        if (isDebug) {
            System.out.println("\nProcessRecord: " + this.typeName);
        }
        HollowDiscoveredSchema schema = this.discoveredSchema(this.typeName, DiscoveredSchemaType.OBJECT, null);
        parser.nextToken();
        this.discoverSchemas(parser, schema);
        return -1;
    }

    public Collection<HollowDiscoveredSchema> discoverSchemas(File jsonFile, Integer maxSample) throws Exception {
        this.processFile(jsonFile, (int)maxSample);
        return this.discoveredSchemas.values();
    }

    public Collection<HollowDiscoveredSchema> discoverSchemas(Reader jsonReader, Integer maxSample) throws Exception {
        this.processFile(jsonReader, (int)maxSample);
        return this.discoveredSchemas.values();
    }

    private void discoverSchemas(JsonParser parser, HollowDiscoveredSchema schema) throws IOException {
        JsonToken token = parser.nextToken();
        while (token != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            this.discoverSchemaField(parser, token, fieldName, schema);
            token = parser.nextToken();
        }
    }

    private void discoverSchemaField(JsonParser parser, JsonToken token, String fieldName, HollowDiscoveredSchema schema) throws IOException {
        if (token != JsonToken.FIELD_NAME) {
            switch (token) {
                case START_ARRAY: {
                    String listName = this.schemaNamer.subCollectionName(schema.schemaName, "ArrayOf", fieldName);
                    String elementName = this.schemaNamer.subObjectName(schema.schemaName, "", fieldName);
                    if (isDebug) {
                        System.out.println(String.format("\t ARR[START] token=%s schemaName=%s fieldName=%s listName=%s elementName=%s", token, schema.schemaName, fieldName, listName, elementName));
                    }
                    this.discoveredSchema(listName, DiscoveredSchemaType.LIST, elementName);
                    schema.addField(fieldName, HollowObjectSchema.FieldType.REFERENCE, listName);
                    HollowDiscoveredSchema elementSchema = this.discoveredSchema(elementName, DiscoveredSchemaType.OBJECT, null);
                    this.discoverSubArraySchemas(parser, elementSchema);
                    if (!isDebug) break;
                    System.out.println(String.format("\t ARR[END] token=%s schemaName=%s fieldName=%s listName=%s elementName=%s elementSchema=%s", token, schema.schemaName, fieldName, listName, elementName, elementSchema));
                    break;
                }
                case START_OBJECT: {
                    String subObjectName = this.schemaNamer.subObjectName(schema.schemaName, "", fieldName);
                    if (this.mapTypes.contains(subObjectName)) {
                        String subMapName = this.schemaNamer.subCollectionName(schema.schemaName, "MapOf", fieldName);
                        if (isDebug) {
                            System.out.println(String.format("\t MAP[START] token=%s schemaName=%s fieldName=%s subMapName=%s subObjectName=%s", token, schema.schemaName, fieldName, subMapName, subObjectName));
                        }
                        this.discoveredSchema(subMapName, DiscoveredSchemaType.MAP, subObjectName);
                        schema.addField(fieldName, HollowObjectSchema.FieldType.REFERENCE, subMapName);
                        HollowDiscoveredSchema valueSchema = this.discoveredSchema(subObjectName, DiscoveredSchemaType.OBJECT, null);
                        this.discoverSubMapSchemas(parser, valueSchema);
                        if (!isDebug) break;
                        System.out.println(String.format("\t MAP[END] token=%s schemaName=%s fieldName=%s subMapName=%s subObjectName=%s valueSchema=%s", token, schema.schemaName, fieldName, subMapName, subObjectName, valueSchema));
                        break;
                    }
                    if (isDebug) {
                        System.out.println(String.format("\t OBJ[START] token=%s schemaName=%s fieldName=%s subObjectName=%s", token, schema.schemaName, fieldName, subObjectName));
                    }
                    HollowDiscoveredSchema subObjectSchema = this.discoveredSchema(subObjectName, DiscoveredSchemaType.OBJECT, null);
                    if (fieldName != null) {
                        schema.addField(fieldName, HollowObjectSchema.FieldType.REFERENCE, subObjectName);
                    }
                    this.discoverSchemas(parser, subObjectSchema);
                    if (!isDebug) break;
                    System.out.println(String.format("\t OBJ[END] token=%s schemaName=%s fieldName=%s subObjectName=%s subObjectSchema=%s", token, schema.schemaName, fieldName, subObjectName, subObjectSchema));
                    break;
                }
                case VALUE_NUMBER_INT: {
                    if (isDebug) {
                        System.out.println(String.format("\t FIELD token=%s schemaName=%s fieldName=%s value=%s", token, schema.schemaName, fieldName, parser.getLongValue()));
                    }
                    schema.addField(fieldName, HollowObjectSchema.FieldType.LONG);
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    if (isDebug) {
                        System.out.println(String.format("\t FIELD token=%s schemaName=%s fieldName=%s value=%s", token, schema.schemaName, fieldName, parser.getDoubleValue()));
                    }
                    schema.addField(fieldName, HollowObjectSchema.FieldType.DOUBLE);
                    break;
                }
                case VALUE_NULL: {
                    if (!isDebug) break;
                    System.out.println(String.format("\t FIELD token=%s schemaName=%s fieldName=%s", token, schema.schemaName, fieldName));
                    break;
                }
                case VALUE_STRING: {
                    if (isDebug) {
                        System.out.println(String.format("\t FIELD token=%s schemaName=%s fieldName=%s value=%s", token, schema.schemaName, fieldName, parser.getValueAsString()));
                    }
                    schema.addField(fieldName, HollowObjectSchema.FieldType.STRING);
                    break;
                }
                case VALUE_FALSE: 
                case VALUE_TRUE: {
                    if (isDebug) {
                        System.out.println(String.format("\t FIELD token=%s schemaName=%s fieldName=%s value=%s", token, schema.schemaName, fieldName, parser.getBooleanValue()));
                    }
                    schema.addField(fieldName, HollowObjectSchema.FieldType.BOOLEAN);
                    break;
                }
            }
        }
    }

    private void discoverSubArraySchemas(JsonParser parser, HollowDiscoveredSchema objectSchema) throws IOException {
        JsonToken token = parser.nextToken();
        while (token != JsonToken.END_ARRAY) {
            if (token == JsonToken.START_OBJECT) {
                this.discoverSchemas(parser, objectSchema);
            } else {
                this.discoverSchemaField(parser, token, "value", objectSchema);
            }
            token = parser.nextToken();
        }
    }

    private void discoverSubMapSchemas(JsonParser parser, HollowDiscoveredSchema objectSchema) throws IOException {
        JsonToken token = parser.nextToken();
        if (isDebug) {
            System.out.println("discoverSubMapSchemas[START]: token=" + token + ", fieldname=" + parser.getCurrentName());
        }
        while (token != JsonToken.END_OBJECT) {
            if (isDebug) {
                System.out.println("discoverSubMapSchemas[LOOP]: token=" + token + ", fieldname=" + parser.getCurrentName());
            }
            if (token != JsonToken.FIELD_NAME) {
                if (token == JsonToken.START_OBJECT) {
                    if (isDebug) {
                        System.out.println("discoverSubMapSchemas[LOOP] discoverSchemas: token=" + token + ", fieldname=" + parser.getCurrentName());
                    }
                    this.discoverSchemas(parser, objectSchema);
                } else {
                    if (isDebug) {
                        System.out.println("discoverSubMapSchemas[LOOP] discoverSchemaField: token=" + token + ", fieldname=" + parser.getCurrentName());
                    }
                    this.discoverSchemaField(parser, token, "value", objectSchema);
                }
            }
            token = parser.nextToken();
        }
        if (isDebug) {
            System.out.println("discoverSubMapSchemas[END]: token=" + token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HollowDiscoveredSchema discoveredSchema(String schemaName, DiscoveredSchemaType type, String listSubType) {
        HollowDiscoveredSchema schema = this.discoveredSchemas.get(schemaName);
        if (schema == null) {
            Map<String, HollowDiscoveredSchema> map = this.discoveredSchemas;
            synchronized (map) {
                schema = this.discoveredSchemas.get(schemaName);
                if (schema == null) {
                    schema = new HollowDiscoveredSchema(schemaName, type, listSubType);
                    this.discoveredSchemas.put(schemaName, schema);
                }
            }
        }
        if (schema.type != type) {
            throw new RuntimeException(schemaName + ": Expected schema of type " + (Object)((Object)type) + " but was " + (Object)((Object)schema.type));
        }
        return schema;
    }

    private static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static void analyzeSchemas(Collection<HollowDiscoveredSchema> schemas, int largeNumOfFieldsThreshold) {
        for (HollowDiscoveredSchema schema : schemas) {
            boolean isObjectWithLargeNumOfFieldsFields = schema.type == DiscoveredSchemaType.OBJECT && schema.fields.size() > largeNumOfFieldsThreshold;
            System.out.print("\t");
            System.out.println(schema);
            int fieldCount = schema.fields.size();
            if (fieldCount == 0) continue;
            int i = 0;
            int maxKeyLen = 0;
            String fieldHeaderTemplate = isObjectWithLargeNumOfFieldsFields ? "[***] Object with lots of fields: %s" : "Field Count: %s";
            StringBuilder builder = new StringBuilder("\t  - ");
            builder.append(String.format(fieldHeaderTemplate, fieldCount)).append("\n");
            for (String string : schema.fields.keySet()) {
                if (string.length() <= maxKeyLen) continue;
                maxKeyLen = string.length();
            }
            for (Map.Entry entry : schema.fields.entrySet()) {
                builder.append("\t\t").append(++i).append(": fieldname=").append(HollowJsonAdapterSchemaDiscoverer.padRight((String)entry.getKey(), maxKeyLen)).append("\t -> ").append(entry.getValue()).append("\n");
            }
            System.out.print(builder);
        }
    }
}

