/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.HollowListWriteRecord;
import com.netflix.hollow.core.write.HollowMapWriteRecord;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.HollowSetWriteRecord;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.jsonadapter.AbstractHollowJsonAdaptorTask;
import com.netflix.hollow.jsonadapter.ObjectFieldMapping;
import com.netflix.hollow.jsonadapter.ObjectMappedFieldPath;
import com.netflix.hollow.jsonadapter.field.FieldProcessor;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HollowJsonAdapter
extends AbstractHollowJsonAdaptorTask {
    final HollowWriteStateEngine stateEngine;
    private final Map<String, HollowSchema> hollowSchemas;
    private final ThreadLocal<Map<String, HollowWriteRecord>> hollowWriteRecordsHolder = new ThreadLocal();
    private final ThreadLocal<Map<String, ObjectFieldMapping>> objectFieldMappingHolder = new ThreadLocal();
    private final Map<String, ObjectFieldMapping> canonicalObjectFieldMappings;
    private final Set<String> passthroughDecoratedTypes;
    private final ThreadLocal<PassthroughWriteRecords> passthroughRecords;

    public HollowJsonAdapter(HollowWriteStateEngine stateEngine, String typeName) {
        super(typeName, "populate");
        this.stateEngine = stateEngine;
        this.hollowSchemas = new HashMap<String, HollowSchema>();
        this.canonicalObjectFieldMappings = new HashMap<String, ObjectFieldMapping>();
        this.passthroughDecoratedTypes = new HashSet<String>();
        for (HollowSchema schema : stateEngine.getSchemas()) {
            this.hollowSchemas.put(schema.getName(), schema);
            if (!(schema instanceof HollowObjectSchema)) continue;
            this.canonicalObjectFieldMappings.put(schema.getName(), new ObjectFieldMapping(schema.getName(), this));
        }
        this.passthroughRecords = new ThreadLocal();
    }

    @Override
    public void addFieldProcessor(FieldProcessor ... processors) {
        super.addFieldProcessor(processors);
        for (FieldProcessor processor : processors) {
            ObjectFieldMapping ofm = this.canonicalObjectFieldMappings.get(processor.getEntityName());
            if (ofm != null) {
                ofm.addFieldProcessor(processor);
                continue;
            }
            for (Map.Entry<String, ObjectFieldMapping> entry : this.canonicalObjectFieldMappings.entrySet()) {
                entry.getValue().addFieldProcessor(processor);
            }
        }
    }

    public void remapFieldPath(String type, String fieldName, String ... fieldPaths) {
        this.canonicalObjectFieldMappings.get(type).addRemappedPath(fieldName, fieldPaths);
    }

    public void addPassthroughDecoratedType(String type) {
        this.passthroughDecoratedTypes.add(type);
    }

    public void populate(File jsonFile) throws Exception {
        this.processFile(jsonFile, Integer.MAX_VALUE);
    }

    public void populate(Reader jsonReader) throws Exception {
        this.processFile(jsonReader, Integer.MAX_VALUE);
    }

    public int processRecord(String singleRecord) throws IOException {
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser((Reader)new StringReader(singleRecord));
        return this.processRecord(parser);
    }

    @Override
    protected int processRecord(JsonParser parser) throws IOException {
        this.initHollowWriteRecordsIfNecessary();
        return this.parseSubType(parser, parser.nextToken(), this.typeName);
    }

    private int parseSubType(JsonParser parser, JsonToken currentToken, String subType) throws IOException {
        HollowSchema subTypeSchema = this.hollowSchemas.get(subType);
        switch (subTypeSchema.getSchemaType()) {
            case OBJECT: {
                if (currentToken != JsonToken.START_OBJECT) {
                    throw new IOException("Expecting to parse a " + subType + ", which is a " + subTypeSchema.getSchemaType() + ", expected JsonToken.START_OBJECT but instead found a " + currentToken.toString());
                }
                return this.addObject(parser, subType);
            }
            case LIST: 
            case SET: {
                if (currentToken != JsonToken.START_ARRAY) {
                    throw new IOException("Expecting to parse a " + subType + ", which is a " + subTypeSchema.getSchemaType() + ", expected JsonToken.START_ARRAY but instead found a " + currentToken.toString());
                }
                return this.addSubArray(parser, subType, this.getWriteRecord(subType));
            }
            case MAP: {
                switch (currentToken) {
                    case START_ARRAY: {
                        return this.addStructuredMap(parser, subType, (HollowMapWriteRecord)this.getWriteRecord(subType));
                    }
                    case START_OBJECT: {
                        return this.addUnstructuredMap(parser, subType, (HollowMapWriteRecord)this.getWriteRecord(subType));
                    }
                }
                throw new IOException("Expecting to parse a " + subType + ", which is a " + subTypeSchema.getSchemaType() + ", expected JsonToken.START_ARRAY or JsonToken.START_OBJECT but instead found a " + currentToken.toString());
            }
        }
        throw new IOException();
    }

    private int addObject(JsonParser parser, String typeName) throws IOException {
        ObjectFieldMapping objectMapping = this.getObjectFieldMapping(typeName);
        Boolean passthroughDecoratedTypes = null;
        JsonToken token = parser.nextToken();
        PassthroughWriteRecords rec = null;
        String fieldName = null;
        try {
            while (token != JsonToken.END_OBJECT) {
                if (token != JsonToken.FIELD_NAME) {
                    fieldName = parser.getCurrentName();
                    ObjectMappedFieldPath mappedFieldPath = objectMapping.getMappedFieldPath(fieldName);
                    if (mappedFieldPath != null) {
                        this.addObjectField(parser, token, mappedFieldPath);
                    } else {
                        if (passthroughDecoratedTypes == null && (passthroughDecoratedTypes = Boolean.valueOf(this.passthroughDecoratedTypes.contains(typeName))).booleanValue()) {
                            rec = this.getPassthroughWriteRecords();
                        }
                        if (passthroughDecoratedTypes.booleanValue()) {
                            this.addPassthroughField(parser, token, fieldName, rec);
                        } else {
                            this.skipObjectField(parser, token);
                        }
                    }
                }
                token = parser.nextToken();
            }
        }
        catch (Exception ex) {
            throw new IOException("Failed to parse field=" + fieldName + ", schema=" + typeName + ", token=" + token, ex);
        }
        if (passthroughDecoratedTypes != null && passthroughDecoratedTypes.booleanValue()) {
            rec.passthroughRec.setReference("singleValues", this.stateEngine.add("SingleValuePassthroughMap", (HollowWriteRecord)rec.singleValuePassthroughMapRec));
            rec.passthroughRec.setReference("multiValues", this.stateEngine.add("MultiValuePassthroughMap", (HollowWriteRecord)rec.multiValuePassthroughMapRec));
            int passthroughOrdinal = this.stateEngine.add("PassthroughData", (HollowWriteRecord)rec.passthroughRec);
            return objectMapping.build(passthroughOrdinal);
        }
        return objectMapping.build(-1);
    }

    private void addPassthroughField(JsonParser parser, JsonToken token, String fieldName, PassthroughWriteRecords rec) throws IOException {
        rec.passthroughMapKeyWriteRecord.reset();
        rec.passthroughMapKeyWriteRecord.setString("value", fieldName);
        int keyOrdinal = this.stateEngine.add("MapKey", (HollowWriteRecord)rec.passthroughMapKeyWriteRecord);
        switch (token) {
            case START_ARRAY: {
                rec.multiValuePassthroughListRec.reset();
                while (token != JsonToken.END_ARRAY) {
                    switch (token) {
                        case VALUE_FALSE: 
                        case VALUE_TRUE: 
                        case VALUE_NUMBER_INT: 
                        case VALUE_NUMBER_FLOAT: 
                        case VALUE_STRING: {
                            rec.passthroughMapValueWriteRecord.reset();
                            rec.passthroughMapValueWriteRecord.setString("value", parser.getValueAsString());
                            int elementOrdinal = this.stateEngine.add("String", (HollowWriteRecord)rec.passthroughMapValueWriteRecord);
                            rec.multiValuePassthroughListRec.addElement(elementOrdinal);
                            break;
                        }
                    }
                    token = parser.nextToken();
                }
                int valueListOrdinal = this.stateEngine.add("ListOfString", (HollowWriteRecord)rec.multiValuePassthroughListRec);
                rec.multiValuePassthroughMapRec.addEntry(keyOrdinal, valueListOrdinal);
                break;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_STRING: {
                rec.passthroughMapValueWriteRecord.reset();
                rec.passthroughMapValueWriteRecord.setString("value", parser.getValueAsString());
                int valueOrdinal = this.stateEngine.add("String", (HollowWriteRecord)rec.passthroughMapValueWriteRecord);
                rec.singleValuePassthroughMapRec.addEntry(keyOrdinal, valueOrdinal);
                break;
            }
            case VALUE_NULL: {
                break;
            }
            case START_OBJECT: {
                this.skipObject(parser);
                break;
            }
        }
    }

    private void addObjectField(JsonParser parser, JsonToken token, ObjectMappedFieldPath mappedFieldPath) throws IOException {
        if (mappedFieldPath == null) {
            this.skipObjectField(parser, token);
        } else {
            HollowObjectWriteRecord writeRec = mappedFieldPath.getWriteRecord();
            HollowObjectSchema schema = writeRec.getSchema();
            String fieldName = mappedFieldPath.getFieldName();
            int fieldPosition = mappedFieldPath.getFieldPosition();
            FieldProcessor processor = mappedFieldPath.getFieldProcessor();
            if (processor != null && token != JsonToken.VALUE_NULL) {
                processor.processField(parser, this.stateEngine, writeRec);
                return;
            }
            block0 : switch (token) {
                case START_ARRAY: 
                case START_OBJECT: {
                    int refOrdinal = this.parseSubType(parser, token, schema.getReferencedType(fieldPosition));
                    writeRec.setReference(fieldName, refOrdinal);
                    break;
                }
                case VALUE_FALSE: 
                case VALUE_TRUE: 
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_STRING: {
                    switch (schema.getFieldType(fieldPosition)) {
                        case BOOLEAN: {
                            writeRec.setBoolean(fieldName, parser.getBooleanValue());
                            break block0;
                        }
                        case INT: {
                            writeRec.setInt(fieldName, parser.getIntValue());
                            break block0;
                        }
                        case LONG: {
                            writeRec.setLong(fieldName, parser.getLongValue());
                            break block0;
                        }
                        case DOUBLE: {
                            writeRec.setDouble(fieldName, parser.getDoubleValue());
                            break block0;
                        }
                        case FLOAT: {
                            writeRec.setFloat(fieldName, parser.getFloatValue());
                            break block0;
                        }
                        case STRING: {
                            writeRec.setString(fieldName, parser.getValueAsString());
                            break block0;
                        }
                        case REFERENCE: {
                            HollowObjectWriteRecord referencedRec = (HollowObjectWriteRecord)this.getWriteRecord(schema.getReferencedType(fieldPosition));
                            referencedRec.reset();
                            String refFieldName = referencedRec.getSchema().getFieldName(0);
                            switch (referencedRec.getSchema().getFieldType(0)) {
                                case BOOLEAN: {
                                    referencedRec.setBoolean(refFieldName, parser.getBooleanValue());
                                    break;
                                }
                                case INT: {
                                    referencedRec.setInt(refFieldName, parser.getIntValue());
                                    break;
                                }
                                case LONG: {
                                    referencedRec.setLong(refFieldName, parser.getLongValue());
                                    break;
                                }
                                case DOUBLE: {
                                    referencedRec.setDouble(refFieldName, parser.getDoubleValue());
                                    break;
                                }
                                case FLOAT: {
                                    referencedRec.setFloat(refFieldName, parser.getFloatValue());
                                    break;
                                }
                                case STRING: {
                                    referencedRec.setString(refFieldName, parser.getValueAsString());
                                    break;
                                }
                            }
                            int referencedOrdinal = this.stateEngine.add(schema.getReferencedType(fieldPosition), (HollowWriteRecord)referencedRec);
                            writeRec.setReference(fieldName, referencedOrdinal);
                            break block0;
                        }
                    }
                }
                case VALUE_NULL: {
                    break;
                }
            }
        }
    }

    private int addSubArray(JsonParser parser, String arrayType, HollowWriteRecord arrayRec) throws IOException {
        JsonToken token = parser.nextToken();
        arrayRec.reset();
        HollowCollectionSchema schema = (HollowCollectionSchema)this.hollowSchemas.get(arrayType);
        ObjectFieldMapping valueRec = null;
        ObjectMappedFieldPath fieldMapping = null;
        while (token != JsonToken.END_ARRAY) {
            int elementOrdinal;
            if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
                elementOrdinal = this.parseSubType(parser, token, schema.getElementType());
            } else {
                if (valueRec == null) {
                    valueRec = this.getObjectFieldMapping(schema.getElementType());
                    fieldMapping = valueRec.getSingleFieldMapping();
                }
                this.addObjectField(parser, token, fieldMapping);
                elementOrdinal = valueRec.build(-1);
            }
            if (arrayRec instanceof HollowListWriteRecord) {
                ((HollowListWriteRecord)arrayRec).addElement(elementOrdinal);
            } else {
                ((HollowSetWriteRecord)arrayRec).addElement(elementOrdinal);
            }
            token = parser.nextToken();
        }
        return this.stateEngine.add(arrayType, arrayRec);
    }

    private int addStructuredMap(JsonParser parser, String mapTypeName, HollowMapWriteRecord mapRec) throws IOException {
        JsonToken token = parser.nextToken();
        mapRec.reset();
        HollowMapSchema schema = (HollowMapSchema)this.hollowSchemas.get(mapTypeName);
        while (token != JsonToken.END_ARRAY) {
            if (token == JsonToken.START_OBJECT) {
                int keyOrdinal = -1;
                int valueOrdinal = -1;
                while (token != JsonToken.END_OBJECT) {
                    if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
                        if ("key".equals(parser.getCurrentName())) {
                            keyOrdinal = this.parseSubType(parser, token, schema.getKeyType());
                        } else if ("value".equals(parser.getCurrentName())) {
                            valueOrdinal = this.parseSubType(parser, token, schema.getValueType());
                        }
                    }
                    token = parser.nextToken();
                }
                mapRec.addEntry(keyOrdinal, valueOrdinal);
            }
            token = parser.nextToken();
        }
        return this.stateEngine.add(schema.getName(), (HollowWriteRecord)mapRec);
    }

    private int addUnstructuredMap(JsonParser parser, String mapTypeName, HollowMapWriteRecord mapRec) throws IOException {
        mapRec.reset();
        HollowMapSchema schema = (HollowMapSchema)this.hollowSchemas.get(mapTypeName);
        ObjectFieldMapping valueRec = null;
        ObjectMappedFieldPath fieldMapping = null;
        JsonToken token = parser.nextToken();
        while (token != JsonToken.END_OBJECT) {
            if (token != JsonToken.FIELD_NAME) {
                int valueOrdinal;
                HollowObjectWriteRecord mapKeyWriteRecord = (HollowObjectWriteRecord)this.getWriteRecord(schema.getKeyType());
                String fieldName = mapKeyWriteRecord.getSchema().getFieldName(0);
                mapKeyWriteRecord.reset();
                switch (mapKeyWriteRecord.getSchema().getFieldType(0)) {
                    case STRING: {
                        mapKeyWriteRecord.setString(fieldName, parser.getCurrentName());
                        break;
                    }
                    case BOOLEAN: {
                        mapKeyWriteRecord.setBoolean(fieldName, Boolean.valueOf(parser.getCurrentName()).booleanValue());
                        break;
                    }
                    case INT: {
                        mapKeyWriteRecord.setInt(fieldName, Integer.parseInt(parser.getCurrentName()));
                        break;
                    }
                    case LONG: {
                        mapKeyWriteRecord.setLong(fieldName, Long.parseLong(parser.getCurrentName()));
                        break;
                    }
                    case DOUBLE: {
                        mapKeyWriteRecord.setDouble(fieldName, Double.parseDouble(parser.getCurrentName()));
                        break;
                    }
                    case FLOAT: {
                        mapKeyWriteRecord.setFloat(fieldName, Float.parseFloat(parser.getCurrentName()));
                        break;
                    }
                    default: {
                        throw new IOException("Cannot parse type " + mapKeyWriteRecord.getSchema().getFieldType(0) + " as key in map (" + mapKeyWriteRecord.getSchema().getName() + ")");
                    }
                }
                int keyOrdinal = this.stateEngine.add(schema.getKeyType(), (HollowWriteRecord)mapKeyWriteRecord);
                if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
                    valueOrdinal = this.parseSubType(parser, token, schema.getValueType());
                } else {
                    if (valueRec == null) {
                        valueRec = this.getObjectFieldMapping(schema.getValueType());
                        fieldMapping = valueRec.getSingleFieldMapping();
                    }
                    this.addObjectField(parser, token, fieldMapping);
                    valueOrdinal = valueRec.build(-1);
                }
                mapRec.addEntry(keyOrdinal, valueOrdinal);
            }
            token = parser.nextToken();
        }
        return this.stateEngine.add(schema.getName(), (HollowWriteRecord)mapRec);
    }

    private void skipObject(JsonParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        try {
            while (token != JsonToken.END_OBJECT) {
                this.skipObjectField(parser, token);
                token = parser.nextToken();
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private void skipSubArray(JsonParser parser) throws IOException {
        JsonToken token = parser.nextToken();
        while (token != JsonToken.END_ARRAY) {
            if (token == JsonToken.START_OBJECT) {
                this.skipObject(parser);
            } else {
                this.skipObjectField(parser, token);
            }
            token = parser.nextToken();
        }
    }

    private void skipObjectField(JsonParser parser, JsonToken token) throws IOException {
        switch (token) {
            case START_ARRAY: {
                this.skipSubArray(parser);
                break;
            }
            case START_OBJECT: {
                this.skipObject(parser);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHollowWriteRecordsIfNecessary() {
        if (this.hollowWriteRecordsHolder.get() == null) {
            HollowJsonAdapter hollowJsonAdapter = this;
            synchronized (hollowJsonAdapter) {
                if (this.hollowWriteRecordsHolder.get() == null) {
                    Map<String, HollowWriteRecord> lookupMap = HollowJsonAdapter.createWriteRecords(this.stateEngine);
                    this.hollowWriteRecordsHolder.set(lookupMap);
                    this.objectFieldMappingHolder.set(this.cloneFieldMappings());
                }
            }
        }
    }

    private static Map<String, HollowWriteRecord> createWriteRecords(HollowWriteStateEngine stateEngine) {
        HashMap<String, HollowWriteRecord> hollowWriteRecords = new HashMap<String, HollowWriteRecord>();
        for (HollowSchema schema : stateEngine.getSchemas()) {
            switch (schema.getSchemaType()) {
                case LIST: {
                    hollowWriteRecords.put(schema.getName(), (HollowWriteRecord)new HollowListWriteRecord());
                    break;
                }
                case MAP: {
                    hollowWriteRecords.put(schema.getName(), (HollowWriteRecord)new HollowMapWriteRecord());
                    break;
                }
                case OBJECT: {
                    hollowWriteRecords.put(schema.getName(), (HollowWriteRecord)new HollowObjectWriteRecord((HollowObjectSchema)schema));
                    break;
                }
                case SET: {
                    hollowWriteRecords.put(schema.getName(), (HollowWriteRecord)new HollowSetWriteRecord());
                }
            }
        }
        return hollowWriteRecords;
    }

    private Map<String, ObjectFieldMapping> cloneFieldMappings() {
        HashMap<String, ObjectFieldMapping> clonedMap = new HashMap<String, ObjectFieldMapping>();
        for (Map.Entry<String, ObjectFieldMapping> entry : this.canonicalObjectFieldMappings.entrySet()) {
            clonedMap.put(entry.getKey(), entry.getValue().clone());
        }
        return clonedMap;
    }

    ObjectFieldMapping getObjectFieldMapping(String type) throws IOException {
        Map<String, ObjectFieldMapping> objectFieldMappings = this.objectFieldMappingHolder.get();
        ObjectFieldMapping mapping = objectFieldMappings.get(type);
        if (mapping == null) {
            throw new IOException("WriteRecord for " + type + " not found.  Make sure Schema Discovery is done correctly.");
        }
        return mapping;
    }

    HollowWriteRecord getWriteRecord(String type) throws IOException {
        Map<String, HollowWriteRecord> hollowWriteRecords = this.hollowWriteRecordsHolder.get();
        HollowWriteRecord wRec = hollowWriteRecords.get(type);
        if (wRec == null) {
            throw new IOException("WriteRecord for " + type + " not found.  Make sure Schema Discovery is done correctly.");
        }
        return wRec;
    }

    private PassthroughWriteRecords getPassthroughWriteRecords() {
        PassthroughWriteRecords rec = this.passthroughRecords.get();
        if (rec == null) {
            rec = new PassthroughWriteRecords();
            this.passthroughRecords.set(rec);
        }
        rec.passthroughRec.reset();
        rec.multiValuePassthroughMapRec.reset();
        rec.singleValuePassthroughMapRec.reset();
        return rec;
    }

    private class PassthroughWriteRecords {
        final HollowObjectWriteRecord passthroughRec;
        final HollowObjectWriteRecord passthroughMapKeyWriteRecord;
        final HollowObjectWriteRecord passthroughMapValueWriteRecord;
        final HollowMapWriteRecord singleValuePassthroughMapRec;
        final HollowMapWriteRecord multiValuePassthroughMapRec;
        final HollowListWriteRecord multiValuePassthroughListRec;

        public PassthroughWriteRecords() {
            this.passthroughRec = HollowJsonAdapter.this.hollowSchemas.get("PassthroughData") != null ? new HollowObjectWriteRecord((HollowObjectSchema)HollowJsonAdapter.this.hollowSchemas.get("PassthroughData")) : null;
            this.passthroughMapKeyWriteRecord = HollowJsonAdapter.this.hollowSchemas.get("MapKey") != null ? new HollowObjectWriteRecord((HollowObjectSchema)HollowJsonAdapter.this.hollowSchemas.get("MapKey")) : null;
            this.passthroughMapValueWriteRecord = HollowJsonAdapter.this.hollowSchemas.get("String") != null ? new HollowObjectWriteRecord((HollowObjectSchema)HollowJsonAdapter.this.hollowSchemas.get("String")) : null;
            this.singleValuePassthroughMapRec = new HollowMapWriteRecord();
            this.multiValuePassthroughMapRec = new HollowMapWriteRecord();
            this.multiValuePassthroughListRec = new HollowListWriteRecord();
        }
    }
}

