/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.jsonadapter.discover;

import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.jsonadapter.discover.HollowDiscoveredSchema;
import java.util.Collection;
import java.util.HashMap;

public class SchemaSolidifier {
    public static Collection<HollowSchema> convertDiscoveredSchemas(Collection<HollowDiscoveredSchema> discoveredSchemas) {
        HashMap<String, Object> schemaMap = new HashMap<String, Object>();
        for (HollowDiscoveredSchema discoveredSchema : discoveredSchemas) {
            HollowSchema schema = discoveredSchema.toHollowSchema();
            schemaMap.put(schema.getName(), schema);
            if (schema instanceof HollowMapSchema) {
                String keyType = ((HollowMapSchema)schema).getKeyType();
                if (schemaMap.containsKey(keyType)) continue;
                schemaMap.put(keyType, SchemaSolidifier.getStringSchema(keyType));
                continue;
            }
            if (!SchemaSolidifier.referencesGenericStringSchema(schema) || schemaMap.containsKey("String")) continue;
            schemaMap.put("String", SchemaSolidifier.getStringSchema("String"));
        }
        return schemaMap.values();
    }

    private static boolean referencesGenericStringSchema(HollowSchema schema) {
        if (schema instanceof HollowObjectSchema) {
            HollowObjectSchema objSchema = (HollowObjectSchema)schema;
            for (int i = 0; i < objSchema.numFields(); ++i) {
                if (!"String".equals(objSchema.getReferencedType(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static HollowObjectSchema getStringSchema(String schemaName) {
        HollowObjectSchema schema = new HollowObjectSchema(schemaName, 1, new String[0]);
        schema.addField("value", HollowObjectSchema.FieldType.STRING);
        return schema;
    }
}

