/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui;

import com.netflix.hollow.api.client.HollowClient;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.explorer.ui.HollowExplorerUI;
import com.netflix.hollow.ui.HollowUIWebServer;
import com.netflix.hollow.ui.HttpHandlerWithServletSupport;
import javax.servlet.http.HttpServlet;

public class HollowExplorerUIServer {
    private final HollowUIWebServer server;
    private final HollowExplorerUI ui;

    public HollowExplorerUIServer(HollowReadStateEngine readEngine, int port) {
        this(new HollowExplorerUI("", readEngine), port);
    }

    public HollowExplorerUIServer(HollowConsumer consumer, int port) {
        this(new HollowExplorerUI("", consumer), port);
    }

    public HollowExplorerUIServer(HollowClient client, int port) {
        this(new HollowExplorerUI("", client), port);
    }

    public HollowExplorerUIServer(HollowExplorerUI ui, int port) {
        this.server = new HollowUIWebServer(new HttpHandlerWithServletSupport((HttpServlet)ui), port);
        this.ui = ui;
    }

    public HollowExplorerUIServer start() throws Exception {
        this.server.start();
        return this;
    }

    public HollowExplorerUIServer join() throws InterruptedException {
        this.server.join();
        return this;
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public HollowExplorerUI getUI() {
        return this.ui;
    }
}

