/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui.pages;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.explorer.ui.HollowExplorerUI;
import com.netflix.hollow.explorer.ui.model.TypeOverview;
import com.netflix.hollow.explorer.ui.pages.HollowExplorerPage;
import com.netflix.hollow.ui.HollowDiffUtil;
import com.netflix.hollow.ui.HollowUISession;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class ShowAllTypesPage
extends HollowExplorerPage {
    public ShowAllTypesPage(HollowExplorerUI ui) {
        super(ui);
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        String sort = req.getParameter("sort") == null ? "primaryKey" : req.getParameter("sort");
        ArrayList<TypeOverview> typeOverviews = new ArrayList<TypeOverview>();
        for (HollowTypeReadState typeState : this.ui.getStateEngine().getTypeStates()) {
            String typeName = typeState.getSchema().getName();
            BitSet populatedOrdinals = typeState.getPopulatedOrdinals();
            int numRecords = populatedOrdinals == null ? Integer.MIN_VALUE : populatedOrdinals.cardinality();
            int numHoles = populatedOrdinals == null ? Integer.MIN_VALUE : populatedOrdinals.length() - populatedOrdinals.cardinality();
            long approxHoleFootprint = typeState.getApproximateHoleCostInBytes();
            PrimaryKey primaryKey = typeState.getSchema().getSchemaType() == HollowSchema.SchemaType.OBJECT ? ((HollowObjectSchema)typeState.getSchema()).getPrimaryKey() : null;
            long approxHeapFootprint = typeState.getApproximateHeapFootprintInBytes();
            HollowSchema schema = typeState.getSchema();
            typeOverviews.add(new TypeOverview(typeName, numRecords, numHoles, approxHoleFootprint, approxHeapFootprint, primaryKey, schema));
        }
        switch (sort) {
            case "typeName": {
                Collections.sort(typeOverviews, new Comparator<TypeOverview>(){

                    @Override
                    public int compare(TypeOverview o1, TypeOverview o2) {
                        return o1.getTypeName().compareTo(o2.getTypeName());
                    }
                });
                break;
            }
            case "numRecords": {
                Collections.sort(typeOverviews, new Comparator<TypeOverview>(){

                    @Override
                    public int compare(TypeOverview o1, TypeOverview o2) {
                        return Integer.compare(o2.getNumRecordsInt(), o1.getNumRecordsInt());
                    }
                });
                break;
            }
            case "numHoles": {
                typeOverviews.sort((o1, o2) -> Integer.compare(o2.getNumHolesInt(), o1.getNumHolesInt()));
                break;
            }
            case "holeSize": {
                typeOverviews.sort((o1, o2) -> Long.compare(o2.getApproxHoleFootprintLong(), o1.getApproxHoleFootprintLong()));
                break;
            }
            case "heapSize": {
                Collections.sort(typeOverviews, new Comparator<TypeOverview>(){

                    @Override
                    public int compare(TypeOverview o1, TypeOverview o2) {
                        return Long.compare(o2.getApproxHeapFootprintLong(), o1.getApproxHeapFootprintLong());
                    }
                });
                break;
            }
            default: {
                Collections.sort(typeOverviews, new Comparator<TypeOverview>(){

                    @Override
                    public int compare(TypeOverview o1, TypeOverview o2) {
                        if (!"".equals(o1.getPrimaryKey()) && "".equals(o2.getPrimaryKey())) {
                            return -1;
                        }
                        if ("".equals(o1.getPrimaryKey()) && !"".equals(o2.getPrimaryKey())) {
                            return 1;
                        }
                        return o1.getTypeName().compareTo(o2.getTypeName());
                    }
                });
            }
        }
        ctx.put("totalHoleFootprint", (Object)this.totalApproximateHoleFootprint(typeOverviews));
        ctx.put("totalHeapFootprint", (Object)this.totalApproximateHeapFootprint(typeOverviews));
        ctx.put("typeOverviews", typeOverviews);
    }

    @Override
    protected void renderPage(HttpServletRequest req, VelocityContext ctx, Writer writer) {
        this.ui.getVelocityEngine().getTemplate("show-all-types.vm").merge((Context)ctx, writer);
    }

    private String totalApproximateHeapFootprint(List<TypeOverview> allTypes) {
        long totalHeapFootprint = 0L;
        for (TypeOverview type : allTypes) {
            totalHeapFootprint += type.getApproxHeapFootprintLong();
        }
        return HollowDiffUtil.formatBytes((long)totalHeapFootprint);
    }

    private String totalApproximateHoleFootprint(List<TypeOverview> allTypes) {
        long totalFootprint = 0L;
        for (TypeOverview type : allTypes) {
            totalFootprint += type.getApproxHoleFootprintLong();
        }
        return HollowDiffUtil.formatBytes((long)totalFootprint);
    }
}

