/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui.pages;

import com.netflix.hollow.explorer.ui.HollowExplorerUI;
import com.netflix.hollow.ui.EscapingTool;
import com.netflix.hollow.ui.HollowUISession;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public abstract class HollowExplorerPage {
    protected final HollowExplorerUI ui;
    private final Template headerTemplate;
    private final Template footerTemplate;

    public HollowExplorerPage(HollowExplorerUI ui) {
        this.ui = ui;
        this.headerTemplate = ui.getVelocityEngine().getTemplate("explorer-header.vm");
        this.footerTemplate = ui.getVelocityEngine().getTemplate("explorer-footer.vm");
    }

    public void render(HttpServletRequest req, HttpServletResponse resp, HollowUISession session) throws IOException {
        String headerDisplayString;
        VelocityContext ctx = new VelocityContext();
        if (this.ui.getCurrentStateVersion() != Long.MIN_VALUE) {
            ctx.put("stateVersion", (Object)this.ui.getCurrentStateVersion());
        }
        if ((headerDisplayString = this.ui.getHeaderDisplayString()) != null) {
            ctx.put("headerDisplayString", (Object)headerDisplayString);
            String headerDisplayURL = this.ui.getFromHeaderDisplayMap(headerDisplayString) != null ? this.ui.getFromHeaderDisplayMap(headerDisplayString) : "";
            ctx.put("headerStringURL", (Object)headerDisplayURL);
        }
        ctx.put("basePath", (Object)this.ui.getBaseURLPath());
        ctx.put("esc", (Object)new EscapingTool());
        this.setUpContext(req, session, ctx);
        resp.setContentType("text/html;charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        this.headerTemplate.merge((Context)ctx, (Writer)writer);
        this.renderPage(req, ctx, writer);
        this.footerTemplate.merge((Context)ctx, (Writer)writer);
    }

    protected abstract void renderPage(HttpServletRequest var1, VelocityContext var2, Writer var3);

    protected abstract void setUpContext(HttpServletRequest var1, HollowUISession var2, VelocityContext var3);
}

