/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui.pages;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.explorer.ui.HollowExplorerUI;
import com.netflix.hollow.explorer.ui.model.QueryResult;
import com.netflix.hollow.explorer.ui.model.TypeKey;
import com.netflix.hollow.explorer.ui.pages.HollowExplorerPage;
import com.netflix.hollow.tools.stringifier.HollowRecordJsonStringifier;
import com.netflix.hollow.tools.stringifier.HollowRecordStringifier;
import com.netflix.hollow.tools.util.SearchUtils;
import com.netflix.hollow.ui.HollowUISession;
import com.netflix.hollow.ui.HtmlEscapingWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class BrowseSelectedTypePage
extends HollowExplorerPage {
    private static final String SESSION_ATTR_QUERY_RESULT = "query-result";

    public BrowseSelectedTypePage(HollowExplorerUI ui) {
        super(ui);
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        HollowTypeReadState typeState = this.getTypeState(req);
        int page = req.getParameter("page") == null ? 0 : Integer.parseInt(req.getParameter("page"));
        int pageSize = req.getParameter("pageSize") == null ? 20 : Integer.parseInt(req.getParameter("pageSize"));
        int startRec = page * pageSize;
        String displayFormat = "json".equals(req.getParameter("display")) ? "json" : "text";
        BitSet selectedOrdinals = typeState.getPopulatedOrdinals();
        if ("true".equals(req.getParameter("clearQuery"))) {
            session.clearAttribute(SESSION_ATTR_QUERY_RESULT);
        }
        if (session.getAttribute(SESSION_ATTR_QUERY_RESULT) != null) {
            QueryResult queryResult = (QueryResult)session.getAttribute(SESSION_ATTR_QUERY_RESULT);
            queryResult.recalculateIfNotCurrent(this.ui.getStateEngine());
            selectedOrdinals = queryResult.getQueryMatches().get(typeState.getSchema().getName());
            if (selectedOrdinals == null) {
                selectedOrdinals = new BitSet();
            }
            ctx.put("filteredByQuery", (Object)queryResult.getQueryDisplayString());
        }
        int currentOrdinal = selectedOrdinals.nextSetBit(0);
        for (int i = 0; i < startRec; ++i) {
            currentOrdinal = selectedOrdinals.nextSetBit(currentOrdinal + 1);
        }
        PrimaryKey primaryKey = SearchUtils.getPrimaryKey((HollowSchema)typeState.getSchema());
        int[][] fieldPathIndexes = SearchUtils.getFieldPathIndexes((HollowReadStateEngine)this.ui.getStateEngine(), (PrimaryKey)primaryKey);
        ArrayList<TypeKey> keys = new ArrayList<TypeKey>(pageSize);
        for (int i = 0; i < pageSize && currentOrdinal != -1; ++i) {
            keys.add(this.getKey(startRec + i, typeState, currentOrdinal, fieldPathIndexes));
            currentOrdinal = selectedOrdinals.nextSetBit(currentOrdinal + 1);
        }
        String key = req.getParameter("key") == null ? "" : req.getParameter("key");
        Object[] parsedKey = null;
        try {
            parsedKey = SearchUtils.parseKey((HollowReadStateEngine)this.ui.getStateEngine(), (PrimaryKey)primaryKey, (String)key);
        }
        catch (Exception e) {
            key = "";
        }
        HollowTypeReadState readTypeState = this.getTypeState(req);
        int ordinal = req.getParameter("ordinal") == null ? -1 : Integer.parseInt(req.getParameter("ordinal"));
        ordinal = SearchUtils.getOrdinalToDisplay((HollowReadStateEngine)this.ui.getStateEngine(), (String)key, (Object[])parsedKey, (int)ordinal, (BitSet)selectedOrdinals, (int[][])fieldPathIndexes, (HollowTypeReadState)readTypeState);
        if (ordinal != -1 && "".equals(key) && fieldPathIndexes != null) {
            key = this.getKey(-1, typeState, ordinal, fieldPathIndexes).getKey();
        }
        int numRecords = selectedOrdinals.cardinality();
        ctx.put("keys", keys);
        ctx.put("page", (Object)page);
        ctx.put("pageSize", (Object)pageSize);
        ctx.put("numPages", (Object)((numRecords - 1) / pageSize + 1));
        ctx.put("numRecords", (Object)numRecords);
        ctx.put("type", (Object)typeState.getSchema().getName());
        ctx.put("key", (Object)key);
        ctx.put("ordinal", (Object)ordinal);
        ctx.put("display", (Object)displayFormat);
    }

    @Override
    protected void renderPage(HttpServletRequest req, VelocityContext ctx, Writer writer) {
        String key = (String)ctx.get("key");
        Integer ordinal = (Integer)ctx.get("ordinal");
        this.ui.getVelocityEngine().getTemplate("browse-selected-type-top.vm").merge((Context)ctx, writer);
        try {
            HtmlEscapingWriter htmlEscapingWriter = new HtmlEscapingWriter(writer);
            if (!"".equals(key) && ordinal != null && ordinal.equals(-1)) {
                htmlEscapingWriter.append("ERROR: Key " + key + " was not found!");
            } else if (ordinal != null && !ordinal.equals(-1)) {
                HollowRecordJsonStringifier stringifier = "json".equals(req.getParameter("display")) ? new HollowRecordJsonStringifier() : new HollowRecordStringifier();
                stringifier.stringify((Writer)htmlEscapingWriter, (HollowDataAccess)this.ui.getStateEngine(), this.getTypeState(req).getSchema().getName(), ordinal.intValue());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error streaming response", e);
        }
        this.ui.getVelocityEngine().getTemplate("browse-selected-type-bottom.vm").merge((Context)ctx, writer);
    }

    private TypeKey getKey(int recordIdx, HollowTypeReadState typeState, int ordinal, int[][] fieldPathIndexes) {
        if (fieldPathIndexes != null) {
            StringBuilder keyBuilder = new StringBuilder();
            StringBuilder delimiterEscapedKeyBuilder = new StringBuilder();
            HollowObjectTypeReadState objState = (HollowObjectTypeReadState)typeState;
            for (int i = 0; i < fieldPathIndexes.length; ++i) {
                int curOrdinal = ordinal;
                HollowObjectTypeReadState curState = objState;
                for (int j = 0; j < fieldPathIndexes[i].length - 1; ++j) {
                    curOrdinal = curState.readOrdinal(curOrdinal, fieldPathIndexes[i][j]);
                    curState = (HollowObjectTypeReadState)curState.getSchema().getReferencedTypeState(fieldPathIndexes[i][j]);
                }
                if (i > 0) {
                    keyBuilder.append(":");
                    delimiterEscapedKeyBuilder.append(":");
                }
                Object fieldValueObject = HollowReadFieldUtils.fieldValueObject((HollowObjectTypeDataAccess)curState, (int)curOrdinal, (int)fieldPathIndexes[i][fieldPathIndexes[i].length - 1]);
                keyBuilder.append(fieldValueObject);
                if (fieldValueObject instanceof String) {
                    delimiterEscapedKeyBuilder.append(((String)fieldValueObject).replaceAll("\\:", "\\\\:"));
                    continue;
                }
                delimiterEscapedKeyBuilder.append(fieldValueObject);
            }
            return new TypeKey(recordIdx, ordinal, delimiterEscapedKeyBuilder.toString(), keyBuilder.toString());
        }
        return new TypeKey(recordIdx, ordinal, "", "ORDINAL:" + ordinal);
    }

    private HollowTypeReadState getTypeState(HttpServletRequest req) {
        return this.ui.getStateEngine().getTypeState(req.getParameter("type"));
    }
}

