/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui.pages;

import com.netflix.hollow.explorer.ui.HollowExplorerUI;
import com.netflix.hollow.explorer.ui.model.SchemaDisplay;
import com.netflix.hollow.explorer.ui.model.SchemaDisplayField;
import com.netflix.hollow.explorer.ui.pages.HollowExplorerPage;
import com.netflix.hollow.ui.HollowUISession;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class BrowseSchemaPage
extends HollowExplorerPage {
    public BrowseSchemaPage(HollowExplorerUI ui) {
        super(ui);
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        String type = req.getParameter("type");
        String expand = req.getParameter("expand");
        String collapse = req.getParameter("collapse");
        SchemaDisplay schemaDisplay = (SchemaDisplay)session.getAttribute("schema-display-" + type);
        if (schemaDisplay == null) {
            schemaDisplay = new SchemaDisplay(this.ui.getStateEngine().getSchema(type));
            schemaDisplay.setExpanded(true);
        }
        if (expand != null) {
            this.expandOrCollapse(schemaDisplay, expand.split("\\."), 1, true);
        }
        if (collapse != null) {
            this.expandOrCollapse(schemaDisplay, collapse.split("\\."), 1, false);
        }
        session.setAttribute("schema-display-" + type, (Object)schemaDisplay);
        ctx.put("schemaDisplay", (Object)schemaDisplay);
        ctx.put("type", (Object)type);
    }

    @Override
    protected void renderPage(HttpServletRequest req, VelocityContext ctx, Writer writer) {
        this.ui.getVelocityEngine().getTemplate("browse-schema.vm").merge((Context)ctx, writer);
    }

    private void expandOrCollapse(SchemaDisplay display, String[] fieldPaths, int cursor, boolean isExpand) {
        if (display == null) {
            return;
        }
        if (cursor >= fieldPaths.length) {
            display.setExpanded(isExpand);
            return;
        }
        for (SchemaDisplayField field : display.getFields()) {
            if (!field.getFieldName().equals(fieldPaths[cursor])) continue;
            this.expandOrCollapse(field.getReferencedType(), fieldPaths, cursor + 1, isExpand);
        }
    }
}

