/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui;

import com.netflix.hollow.api.client.HollowClient;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.explorer.ui.pages.BrowseSchemaPage;
import com.netflix.hollow.explorer.ui.pages.BrowseSelectedTypePage;
import com.netflix.hollow.explorer.ui.pages.QueryPage;
import com.netflix.hollow.explorer.ui.pages.ShowAllTypesPage;
import com.netflix.hollow.ui.HollowUIRouter;
import com.netflix.hollow.ui.HollowUISession;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HollowExplorerUI
extends HollowUIRouter {
    private final HollowConsumer consumer;
    private final HollowClient client;
    private final HollowReadStateEngine stateEngine;
    private final HashMap<String, String> headerDisplayMap = new HashMap();
    private static final String HEADER_DISPLAY_STRING = "headerDisplayString";
    private final ShowAllTypesPage showAllTypesPage;
    private final BrowseSelectedTypePage browseTypePage;
    private final BrowseSchemaPage browseSchemaPage;
    private final QueryPage queryPage;

    public HollowExplorerUI(String baseUrlPath, HollowConsumer consumer) {
        this(baseUrlPath, consumer, null, null);
    }

    public HollowExplorerUI(String baseUrlPath, HollowClient client) {
        this(baseUrlPath, null, client, null);
    }

    public HollowExplorerUI(String baseUrlPath, HollowReadStateEngine stateEngine) {
        this(baseUrlPath, null, null, stateEngine);
    }

    private HollowExplorerUI(String baseUrlPath, HollowConsumer consumer, HollowClient client, HollowReadStateEngine stateEngine) {
        super(baseUrlPath);
        this.consumer = consumer;
        this.client = client;
        this.stateEngine = stateEngine;
        this.showAllTypesPage = new ShowAllTypesPage(this);
        this.browseTypePage = new BrowseSelectedTypePage(this);
        this.browseSchemaPage = new BrowseSchemaPage(this);
        this.queryPage = new QueryPage(this);
    }

    public void handle(String target, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pageName = this.getTargetRootPath(target);
        HollowUISession session = HollowUISession.getSession((HttpServletRequest)req, (HttpServletResponse)resp);
        if ("".equals(pageName) || "home".equals(pageName)) {
            this.showAllTypesPage.render(req, resp, session);
            return;
        }
        if ("type".equals(pageName)) {
            this.browseTypePage.render(req, resp, session);
            return;
        }
        if ("schema".equals(pageName)) {
            this.browseSchemaPage.render(req, resp, session);
            return;
        }
        if ("query".equals(pageName)) {
            this.queryPage.render(req, resp, session);
            return;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handle(req.getPathInfo(), req, resp);
    }

    public long getCurrentStateVersion() {
        if (this.consumer != null) {
            return this.consumer.getCurrentVersionId();
        }
        if (this.client != null) {
            return this.client.getCurrentVersionId();
        }
        return Long.MIN_VALUE;
    }

    public HollowReadStateEngine getStateEngine() {
        if (this.consumer != null) {
            return this.consumer.getStateEngine();
        }
        if (this.client != null) {
            return this.client.getStateEngine();
        }
        return this.stateEngine;
    }

    public String getHeaderDisplayString() {
        return this.headerDisplayMap.get(HEADER_DISPLAY_STRING);
    }

    public void setHeaderDisplayString(String str) {
        this.headerDisplayMap.put(HEADER_DISPLAY_STRING, str);
    }

    public void addToHeaderDisplayMap(String key, String value) {
        this.headerDisplayMap.put(key, value);
    }

    public String getFromHeaderDisplayMap(String key) {
        return this.headerDisplayMap.get(key);
    }
}

