/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui.jetty;

import com.netflix.hollow.api.client.HollowClient;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.explorer.ui.HollowExplorerUI;
import com.netflix.hollow.explorer.ui.jetty.OptionalDependencyHelper;

public class HollowExplorerUIServer {
    private static final UIServer.Factory FACTORY = new OptionalDependencyHelper().explorerUIServerFactory();
    private final UIServer server;
    private final HollowExplorerUI ui;

    public HollowExplorerUIServer(HollowReadStateEngine readEngine, int port) {
        this(new HollowExplorerUI("", readEngine), port);
    }

    public HollowExplorerUIServer(HollowConsumer consumer, int port) {
        this(new HollowExplorerUI("", consumer), port);
    }

    public HollowExplorerUIServer(HollowClient client, int port) {
        this(new HollowExplorerUI("", client), port);
    }

    public HollowExplorerUIServer(HollowExplorerUI ui, int port) {
        this.server = FACTORY.newServer(ui, port);
        this.ui = ui;
    }

    public HollowExplorerUIServer start() throws Exception {
        this.server.start();
        return this;
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public HollowExplorerUIServer join() throws InterruptedException {
        this.server.join();
        return this;
    }

    public HollowExplorerUI getUI() {
        return this.ui;
    }

    static interface UIServer {
        public void start() throws Exception;

        public void stop() throws Exception;

        public void join() throws InterruptedException;

        public static interface Factory {
            public UIServer newServer(HollowExplorerUI var1, int var2);
        }
    }
}

