/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.explorer.ui.pages;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.explorer.ui.HollowExplorerUI;
import com.netflix.hollow.explorer.ui.model.QueryResult;
import com.netflix.hollow.explorer.ui.pages.HollowExplorerPage;
import com.netflix.hollow.ui.HollowUISession;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class QueryPage
extends HollowExplorerPage {
    public QueryPage(HollowExplorerUI ui) {
        super(ui);
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        if ("true".equals(req.getParameter("clear"))) {
            session.clearAttribute("query-result");
        }
        String type = req.getParameter("type");
        String field = req.getParameter("field");
        if ("ANY TYPE".equals(type)) {
            type = null;
        }
        String queryValue = req.getParameter("queryValue");
        ArrayList<String> allTypes = new ArrayList<String>();
        for (HollowSchema schema : this.ui.getStateEngine().getSchemas()) {
            allTypes.add(schema.getName());
        }
        Collections.sort(allTypes);
        QueryResult result = (QueryResult)session.getAttribute("query-result");
        if (result != null) {
            result.recalculateIfNotCurrent(this.ui.getStateEngine());
        }
        if (field != null && queryValue != null) {
            HollowReadStateEngine stateEngine = this.ui.getStateEngine();
            QueryResult.QueryClause queryClause = new QueryResult.QueryClause(type, field, queryValue);
            if (result == null) {
                result = new QueryResult(stateEngine.getCurrentRandomizedTag());
                session.setAttribute("query-result", (Object)result);
            }
            result.augmentQuery(queryClause, this.ui.getStateEngine());
            type = null;
            field = null;
            queryValue = null;
        }
        ctx.put("allTypes", allTypes);
        ctx.put("selectedType", (Object)type);
        ctx.put("selectedField", (Object)field);
        ctx.put("queryValue", (Object)queryValue);
        ctx.put("queryResult", session.getAttribute("query-result"));
    }

    @Override
    protected void renderPage(HttpServletRequest req, VelocityContext ctx, Writer writer) {
        this.ui.getVelocityEngine().getTemplate("query.vm").merge((Context)ctx, writer);
    }
}

