/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui.pages;

import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.diff.ui.HollowDiffUI;
import com.netflix.hollow.diff.ui.model.HollowDiffOverviewTypeEntry;
import com.netflix.hollow.diff.ui.pages.DiffPage;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import com.netflix.hollow.ui.HollowUISession;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;

public class DiffOverviewPage
extends DiffPage {
    public DiffOverviewPage(HollowDiffUI diffUI) {
        super(diffUI, "diff-overview.vm");
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        String sortBy = this.param(req, session, "overview", "sortBy", "diffs");
        ctx.put("typeOverviewEntries", this.getTypeEntries(sortBy));
    }

    private List<HollowDiffOverviewTypeEntry> getTypeEntries(String sortBy) {
        ArrayList<HollowDiffOverviewTypeEntry> overviewEntries = new ArrayList<HollowDiffOverviewTypeEntry>();
        for (HollowTypeDiff diff : this.getDiff().getTypeDiffs()) {
            long totalDiffScore = diff.getTotalDiffScore();
            int unmatchedInFrom = diff.getUnmatchedOrdinalsInFrom().size();
            int unmatchedInTo = diff.getUnmatchedOrdinalsInTo().size();
            int fromCount = 0;
            try {
                fromCount = diff.getTotalItemsInFromState();
            }
            catch (Exception ex) {
                System.out.println("DIFF_ERROR: Unable to getTotalItemsInFromState for type=" + diff.getTypeName());
                ex.printStackTrace();
            }
            int toCount = 0;
            try {
                toCount = diff.getTotalItemsInToState();
            }
            catch (Exception ex) {
                System.out.println("DIFF_ERROR: Unable to getTotalItemsInToState for type=" + diff.getTypeName());
                ex.printStackTrace();
            }
            HollowObjectTypeReadState fromTypeState = diff.getFromTypeState();
            HollowObjectTypeReadState toTypeState = diff.getToTypeState();
            overviewEntries.add(new HollowDiffOverviewTypeEntry(diff.getTypeName(), diff.hasMatchPaths(), totalDiffScore, unmatchedInFrom, unmatchedInTo, fromCount, toCount, fromTypeState == null ? 0L : fromTypeState.getApproximateHeapFootprintInBytes(), toTypeState == null ? 0L : toTypeState.getApproximateHeapFootprintInBytes(), fromTypeState == null ? 0L : fromTypeState.getApproximateHoleCostInBytes(), toTypeState == null ? 0L : toTypeState.getApproximateHoleCostInBytes()));
        }
        if (sortBy == null || "diffs".equals(sortBy)) {
            overviewEntries.sort((o1, o2) -> {
                int result = Comparator.comparing(HollowDiffOverviewTypeEntry::getTotalDiffScore).thenComparing(HollowDiffOverviewTypeEntry::getDeltaSize).thenComparing(HollowDiffOverviewTypeEntry::hasData).thenComparing(HollowDiffOverviewTypeEntry::hasUnmatched).thenComparing(HollowDiffOverviewTypeEntry::hasUniqueKey).compare((HollowDiffOverviewTypeEntry)o2, (HollowDiffOverviewTypeEntry)o1);
                if (result == 0) {
                    return o1.getTypeName().compareTo(o2.getTypeName());
                }
                return result;
            });
        } else if ("unmatchedFrom".equals(sortBy)) {
            overviewEntries.sort((o1, o2) -> o2.getUnmatchedInFrom() - o1.getUnmatchedInFrom());
        } else if ("unmatchedTo".equals(sortBy)) {
            overviewEntries.sort((o1, o2) -> o2.getUnmatchedInTo() - o1.getUnmatchedInTo());
        } else if ("fromCount".equals(sortBy)) {
            overviewEntries.sort((o1, o2) -> o2.getTotalInFrom() - o1.getTotalInFrom());
        } else if ("toCount".equals(sortBy)) {
            overviewEntries.sort((o1, o2) -> o2.getTotalInTo() - o1.getTotalInTo());
        } else if ("fromHeap".equals(sortBy)) {
            overviewEntries.sort((o1, o2) -> (int)(o2.getHeapInFrom() - o1.getHeapInFrom()));
        } else if ("toHeap".equals(sortBy)) {
            overviewEntries.sort((o1, o2) -> (int)(o2.getHeapInTo() - o1.getHeapInTo()));
        } else if ("fromHole".equals(sortBy)) {
            overviewEntries.sort((o1, o2) -> (int)(o2.getHoleInFrom() - o1.getHoleInFrom()));
        } else if ("toHole".equals(sortBy)) {
            overviewEntries.sort((o1, o2) -> (int)(o2.getHoleInTo() - o1.getHoleInTo()));
        }
        return overviewEntries;
    }
}

