/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui.model;

import com.netflix.hollow.ui.HollowDiffUtil;

public class HollowDiffOverviewTypeEntry {
    private final String typeName;
    private final long totalDiffScore;
    private final int unmatchedInFrom;
    private final int unmatchedInTo;
    private final int totalInFrom;
    private final int totalInTo;
    private final long heapInFrom;
    private final long heapInTo;
    private final long holeInFrom;
    private final long holeInTo;

    public HollowDiffOverviewTypeEntry(String typeName, long totalDiffScore, int unmatchedInFrom, int unmatchedInTo, int totalInFrom, int totalInTo) {
        this(typeName, totalDiffScore, unmatchedInFrom, unmatchedInTo, totalInFrom, totalInTo, 0L, 0L, 0L, 0L);
    }

    public HollowDiffOverviewTypeEntry(String typeName, long totalDiffScore, int unmatchedInFrom, int unmatchedInTo, int totalInFrom, int totalInTo, long heapInFrom, long heapInTo, long holeInFrom, long holeInTo) {
        this.typeName = typeName;
        this.totalDiffScore = totalDiffScore;
        this.unmatchedInFrom = unmatchedInFrom;
        this.unmatchedInTo = unmatchedInTo;
        this.totalInFrom = totalInFrom;
        this.totalInTo = totalInTo;
        this.heapInFrom = heapInFrom;
        this.heapInTo = heapInTo;
        this.holeInFrom = holeInFrom;
        this.holeInTo = holeInTo;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public long getTotalDiffScore() {
        return this.totalDiffScore;
    }

    public int getUnmatchedInFrom() {
        return this.unmatchedInFrom;
    }

    public int getUnmatchedInTo() {
        return this.unmatchedInTo;
    }

    public int getTotalInFrom() {
        return this.totalInFrom;
    }

    public int getTotalInTo() {
        return this.totalInTo;
    }

    public long getHeapInFrom() {
        return this.heapInFrom;
    }

    public long getHeapInTo() {
        return this.heapInTo;
    }

    public long getHoleInFrom() {
        return this.holeInFrom;
    }

    public long getHoleInTo() {
        return this.holeInTo;
    }

    public String getHeapInFromFormatted() {
        return HollowDiffUtil.formatBytes((long)this.heapInFrom);
    }

    public String getHeapInToFormatted() {
        return HollowDiffUtil.formatBytes((long)this.heapInTo);
    }

    public String getHoleInFromFormatted() {
        return HollowDiffUtil.formatBytes((long)this.holeInFrom);
    }

    public String getHoleInToFormatted() {
        return HollowDiffUtil.formatBytes((long)this.holeInTo);
    }

    public String getBgColor() {
        if (this.totalDiffScore > 0L || this.unmatchedInFrom > 0 || this.unmatchedInTo > 0) {
            return "#FFCC99";
        }
        if (this.totalInFrom == 0 && this.totalInTo == 0) {
            return "#D0D0D0";
        }
        return "";
    }
}

