/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.pages;

import com.google.gson.Gson;
import com.netflix.hollow.history.ui.HollowHistoryUI;
import com.netflix.hollow.history.ui.model.HistoryStateTypeChanges;
import com.netflix.hollow.history.ui.model.RecordDiff;
import com.netflix.hollow.history.ui.model.RecordDiffTreeNode;
import com.netflix.hollow.history.ui.naming.HollowHistoryRecordNamer;
import com.netflix.hollow.history.ui.pages.HistoryPage;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import com.netflix.hollow.ui.HollowUISession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;

public class HistoryStateTypePage
extends HistoryPage {
    private static final String STATE_TYPE_CHANGES_SESSION_ATTRIBUTE_NAME = "HISTORY_STATE_TYPE_CHANGES";

    public HistoryStateTypePage(HollowHistoryUI ui) {
        super(ui, "history-state-type.vm");
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowUISession session, VelocityContext ctx) {
        long version = Long.parseLong(req.getParameter("version"));
        HistoryStateTypeChanges typeChange = HistoryStateTypePage.getStateTypeChanges(req, session, this.ui);
        HollowHistoricalState historicalState = this.ui.getHistory().getHistoricalState(version);
        ArrayList<String> groupByOptions = new ArrayList<String>(Arrays.asList(historicalState.getKeyOrdinalMapping().getTypeMapping(req.getParameter("type")).getKeyIndex().getKeyFields()));
        groupByOptions.removeAll(Arrays.asList(typeChange.getGroupedFieldNames()));
        ctx.put("typeChange", (Object)typeChange);
        ctx.put("headerEntries", this.getHeaderEntries(historicalState));
        ctx.put("groupBy", (Object)(req.getParameter("groupBy") == null ? "" : req.getParameter("groupBy")));
        ctx.put("groupByOptions", groupByOptions);
    }

    public void sendJson(HttpServletRequest request, HollowUISession session, HttpServletResponse response) {
        ArrayList<String> data;
        ArrayList idRecords;
        ArrayList<String> data2;
        ArrayList idRecords2;
        long version = Long.parseLong(request.getParameter("version"));
        HistoryStateTypeChanges typeChange = HistoryStateTypePage.getStateTypeChanges(request, session, this.ui);
        HollowHistoricalState historicalState = this.ui.getHistory().getHistoricalState(version);
        ArrayList<String> groupByOptions = new ArrayList<String>(Arrays.asList(historicalState.getKeyOrdinalMapping().getTypeMapping(request.getParameter("type")).getKeyIndex().getKeyFields()));
        groupByOptions.removeAll(Arrays.asList(typeChange.getGroupedFieldNames()));
        LinkedHashMap changes = new LinkedHashMap();
        ArrayList<ArrayList<String>> groups = new ArrayList<ArrayList<String>>();
        groups.add(groupByOptions);
        changes.put("groups", groups);
        if (typeChange.getAddedRecords().isEmpty()) {
            changes.put("additions", new ArrayList());
        } else if (!typeChange.getAddedRecords().hasSubGroups()) {
            List<RecordDiff> addedDiffs = typeChange.getAddedRecords().getRecordDiffs();
            idRecords2 = new ArrayList();
            for (RecordDiff diff : addedDiffs) {
                data2 = new ArrayList<String>();
                data2.add(diff.getIdentifierString());
                data2.add(new Integer(diff.getKeyOrdinal()).toString());
                idRecords2.add(data2);
            }
            changes.put("additions", idRecords2);
        } else {
            idRecords = new ArrayList();
            for (RecordDiffTreeNode changeGroup : typeChange.getAddedRecords().getSubGroups()) {
                data = new ArrayList<String>();
                data.add(changeGroup.getGroupName() + "(" + changeGroup.getDiffCount() + ")");
                data.add(changeGroup.getHierarchicalFieldName());
                idRecords.add(data);
            }
            changes.put("additions", idRecords);
        }
        if (typeChange.getModifiedRecords().isEmpty()) {
            changes.put("modifications", new ArrayList());
        } else if (!typeChange.getModifiedRecords().hasSubGroups()) {
            List<RecordDiff> modifiedDiffs = typeChange.getModifiedRecords().getRecordDiffs();
            idRecords2 = new ArrayList();
            for (RecordDiff diff : modifiedDiffs) {
                data2 = new ArrayList();
                data2.add(diff.getIdentifierString());
                data2.add(new Integer(diff.getKeyOrdinal()).toString());
                idRecords2.add(data2);
            }
            changes.put("modifications", idRecords2);
        } else {
            idRecords = new ArrayList();
            for (RecordDiffTreeNode changeGroup : typeChange.getModifiedRecords().getSubGroups()) {
                data = new ArrayList();
                data.add(changeGroup.getGroupName() + "(" + changeGroup.getDiffCount() + ")");
                data.add(changeGroup.getHierarchicalFieldName());
                idRecords.add(data);
            }
            changes.put("modifications", idRecords);
        }
        if (typeChange.getRemovedRecords().isEmpty()) {
            changes.put("removals", new ArrayList());
        } else if (!typeChange.getRemovedRecords().hasSubGroups()) {
            List<RecordDiff> removedDiffs = typeChange.getRemovedRecords().getRecordDiffs();
            idRecords2 = new ArrayList();
            for (RecordDiff diff : removedDiffs) {
                data2 = new ArrayList();
                data2.add(diff.getIdentifierString());
                data2.add(new Integer(diff.getKeyOrdinal()).toString());
                idRecords2.add(data2);
            }
            changes.put("removals", idRecords2);
        } else {
            idRecords = new ArrayList();
            for (RecordDiffTreeNode changeGroup : typeChange.getRemovedRecords().getSubGroups()) {
                data = new ArrayList();
                data.add(changeGroup.getGroupName() + "(" + changeGroup.getDiffCount() + ")");
                data.add(changeGroup.getHierarchicalFieldName());
                idRecords.add(data);
            }
            changes.put("removals", idRecords);
        }
        try {
            PrintWriter out = response.getWriter();
            Gson gson = new Gson();
            String json = gson.toJson(changes, changes.getClass());
            out.println(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HistoryStateTypeChanges getStateTypeChanges(HttpServletRequest req, HollowUISession session, HollowHistoryUI ui) {
        HistoryStateTypeChanges typeChanges = (HistoryStateTypeChanges)session.getAttribute(STATE_TYPE_CHANGES_SESSION_ATTRIBUTE_NAME);
        long version = Long.parseLong(req.getParameter("version"));
        String type = req.getParameter("type");
        String groupBy = req.getParameter("groupBy");
        Object[] groupedFieldNames = HistoryStateTypePage.getGroupedFieldNames(groupBy);
        if (typeChanges == null || version != typeChanges.getStateVersion() || !type.equals(typeChanges.getTypeName()) || !Arrays.equals(groupedFieldNames, typeChanges.getGroupedFieldNames())) {
            HollowHistoricalState historicalState = ui.getHistory().getHistoricalState(Long.parseLong(req.getParameter("version")));
            HollowHistoryRecordNamer recordNamer = ui.getHistoryRecordNamer(type);
            typeChanges = new HistoryStateTypeChanges(historicalState, type, recordNamer, (String[])groupedFieldNames);
            session.setAttribute(STATE_TYPE_CHANGES_SESSION_ATTRIBUTE_NAME, (Object)typeChanges);
        }
        return typeChanges;
    }

    private static String[] getGroupedFieldNames(String groupBy) {
        if (groupBy == null) {
            return new String[0];
        }
        return groupBy.split(",");
    }
}

