/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview.effigy.pairer;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.diffview.effigy.HollowEffigy;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyCollectionPairer;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyMapPairer;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyNullPartnerPairer;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyObjectPairer;
import java.util.List;
import java.util.Map;

public abstract class HollowEffigyFieldPairer {
    protected final HollowEffigy from;
    protected final HollowEffigy to;

    public HollowEffigyFieldPairer(HollowEffigy from, HollowEffigy to) {
        this.from = from;
        this.to = to;
    }

    public abstract List<EffigyFieldPair> pair();

    public static List<EffigyFieldPair> pair(HollowEffigy from, HollowEffigy to, Map<String, PrimaryKey> matchHints, long deadlineBeforePairingTimeout) {
        if (from == null || to == null) {
            return new HollowEffigyNullPartnerPairer(from, to).pair();
        }
        if (from.getDataAccess() == null) {
            return new HollowEffigyObjectPairer(from, to).pair();
        }
        HollowSchema schema = from.getDataAccess().getSchema();
        switch (schema.getSchemaType()) {
            case OBJECT: {
                return new HollowEffigyObjectPairer(from, to).pair();
            }
            case MAP: {
                String keyType = ((HollowMapSchema)schema).getKeyType();
                return new HollowEffigyMapPairer(from, to, matchHints.get(keyType), deadlineBeforePairingTimeout).pair();
            }
            case LIST: 
            case SET: {
                String elementType = ((HollowCollectionSchema)schema).getElementType();
                return new HollowEffigyCollectionPairer(from, to, matchHints.get(elementType), deadlineBeforePairingTimeout).pair();
            }
        }
        throw new IllegalArgumentException("I don't know how to pair fields for type " + schema.getName() + "(" + schema.getSchemaType() + ")");
    }

    public static class EffigyFieldPair {
        private final HollowEffigy.Field from;
        private final HollowEffigy.Field to;
        private final int fromIdx;
        private final int toIdx;
        private final boolean isDiff;

        public EffigyFieldPair(HollowEffigy.Field from, HollowEffigy.Field to, int fromIdx, int toIdx) {
            this.from = from;
            this.to = to;
            this.fromIdx = fromIdx;
            this.toIdx = toIdx;
            this.isDiff = this.calculateIsDiff();
        }

        private boolean calculateIsDiff() {
            if (this.from == null && this.to != null || this.from != null && this.to == null) {
                return true;
            }
            if (this.from.getValue() == null) {
                return this.to.getValue() != null;
            }
            if (this.isLeafNode()) {
                return !this.from.getValue().equals(this.to.getValue());
            }
            return false;
        }

        public HollowEffigy.Field getFrom() {
            return this.from;
        }

        public HollowEffigy.Field getTo() {
            return this.to;
        }

        public int getFromIdx() {
            return this.fromIdx;
        }

        public int getToIdx() {
            return this.toIdx;
        }

        public boolean isLeafNode() {
            return this.from != null && this.from.getValue() != null ? this.from.isLeafNode() : (this.to == null ? true : this.to.isLeafNode());
        }

        public boolean isDiff() {
            return this.isDiff;
        }

        public boolean isOrderingDiff() {
            return this.fromIdx != this.toIdx;
        }
    }
}

