/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.diffview.HollowDiffViewRow;
import com.netflix.hollow.diffview.effigy.HollowEffigy;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyFieldPairer;
import com.netflix.hollow.diffview.effigy.pairer.exact.ExactRecordMatcher;

public abstract class HollowObjectView {
    private static final int MAX_INITIAL_VISIBLE_ROWS_BEFORE_COLLAPSING_DIFFS = 300;
    private final HollowDiffViewRow rootRow;
    private final ExactRecordMatcher exactRecordMatcher;
    private int totalVisibilityCount;

    public HollowObjectView(HollowDiffViewRow rootRow, ExactRecordMatcher exactRecordMatcher) {
        this.rootRow = rootRow;
        this.exactRecordMatcher = exactRecordMatcher;
    }

    public HollowDiffViewRow getRootRow() {
        return this.rootRow;
    }

    public void resetView() {
        this.totalVisibilityCount = 0;
        int totalVisibleRows = this.resetViewForDiff(this.rootRow, 0);
        for (HollowDiffViewRow child : this.rootRow.getChildren()) {
            child.setVisibility(true);
        }
        if (totalVisibleRows > 300) {
            this.collapseChildrenUnderRootDiffRows(this.rootRow);
        } else if (totalVisibleRows == 0 && (totalVisibleRows = this.resetViewForOrderingChanges(this.rootRow, 0)) > 300) {
            this.collapseChildrenUnderRootOrderingDiffRows(this.rootRow);
        }
    }

    private int resetViewForDiff(HollowDiffViewRow row, int runningVisibilityCount) {
        if (this.rowIsExactMatch(row)) {
            return 0;
        }
        int branchVisibilityCount = 0;
        if (row.getFieldPair().isDiff()) {
            row.setVisibility(true);
            ++this.totalVisibilityCount;
            ++branchVisibilityCount;
            branchVisibilityCount += this.makeAllChildrenVisible(row, branchVisibilityCount + runningVisibilityCount);
        } else {
            for (HollowDiffViewRow child : row.getChildren()) {
                if ((branchVisibilityCount += this.resetViewForDiff(child, branchVisibilityCount + runningVisibilityCount)) <= 0) continue;
                row.setVisibility(true);
                ++this.totalVisibilityCount;
                ++branchVisibilityCount;
            }
        }
        return branchVisibilityCount;
    }

    private int makeAllChildrenVisible(HollowDiffViewRow row, int runningVisibilityCount) {
        if (this.totalVisibilityCount > 300) {
            return 0;
        }
        int branchVisibilityCount = 0;
        for (HollowDiffViewRow child : row.getChildren()) {
            child.setVisibility(true);
            ++this.totalVisibilityCount;
            ++branchVisibilityCount;
            branchVisibilityCount += this.makeAllChildrenVisible(child, branchVisibilityCount);
        }
        return branchVisibilityCount;
    }

    private void collapseChildrenUnderRootDiffRows(HollowDiffViewRow row) {
        if (row.areChildrenPopulated()) {
            for (HollowDiffViewRow child : row.getChildren()) {
                if (child.getFieldPair().isDiff()) {
                    this.makeAllChildrenInvisible(child);
                    continue;
                }
                this.collapseChildrenUnderRootDiffRows(child);
            }
        }
    }

    private int resetViewForOrderingChanges(HollowDiffViewRow row, int runningVisibilityCount) {
        if (this.rowIsExactMatch(row)) {
            return 0;
        }
        int branchVisibilityCount = 0;
        if (row.getFieldPair().isOrderingDiff()) {
            row.setVisibility(true);
            ++branchVisibilityCount;
        } else {
            for (HollowDiffViewRow child : row.getChildren()) {
                int childBranchVisibilityCount = this.resetViewForOrderingChanges(child, runningVisibilityCount + branchVisibilityCount);
                if (childBranchVisibilityCount <= 0) continue;
                row.setVisibility(true);
                branchVisibilityCount += childBranchVisibilityCount;
            }
        }
        return branchVisibilityCount;
    }

    private void collapseChildrenUnderRootOrderingDiffRows(HollowDiffViewRow row) {
        if (row.areChildrenPopulated()) {
            for (HollowDiffViewRow child : row.getChildren()) {
                if (child.getFieldPair().isOrderingDiff()) {
                    this.makeAllChildrenInvisible(child);
                    continue;
                }
                this.collapseChildrenUnderRootOrderingDiffRows(child);
            }
        }
    }

    private void makeAllChildrenInvisible(HollowDiffViewRow row) {
        if (row.areChildrenPopulated()) {
            for (HollowDiffViewRow child : row.getChildren()) {
                child.setVisibility(false);
                this.makeAllChildrenInvisible(child);
            }
        }
    }

    private boolean rowIsExactMatch(HollowDiffViewRow row) {
        HollowEffigyFieldPairer.EffigyFieldPair fieldPair = row.getFieldPair();
        if (fieldPair.getFrom() == null || fieldPair.getTo() == null || fieldPair.isLeafNode()) {
            return false;
        }
        HollowEffigy fromEffigy = (HollowEffigy)fieldPair.getFrom().getValue();
        HollowEffigy toEffigy = (HollowEffigy)fieldPair.getTo().getValue();
        if (fromEffigy == null || toEffigy == null) {
            return false;
        }
        return this.exactRecordMatcher.isExactMatch(fromEffigy.getDataAccess(), fromEffigy.getOrdinal(), toEffigy.getDataAccess(), toEffigy.getOrdinal());
    }
}

