/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview;

import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.diff.ui.HollowDiffSession;
import com.netflix.hollow.diffview.HollowDiffViewRow;
import com.netflix.hollow.diffview.HollowHistoryView;
import com.netflix.hollow.diffview.HollowObjectDiffViewGenerator;
import com.netflix.hollow.diffview.HollowObjectViewProvider;
import com.netflix.hollow.history.ui.HollowHistoryUI;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import com.netflix.hollow.tools.history.keyindex.HollowHistoricalStateTypeKeyOrdinalMapping;
import javax.servlet.http.HttpServletRequest;

public class HollowHistoryViewProvider
implements HollowObjectViewProvider {
    private final HollowHistoryUI historyUI;

    public HollowHistoryViewProvider(HollowHistoryUI historyUI) {
        this.historyUI = historyUI;
    }

    @Override
    public HollowHistoryView getObjectView(HttpServletRequest req, HollowDiffSession session) {
        long version = Long.parseLong(req.getParameter("version"));
        String type = req.getParameter("type");
        int keyOrdinal = Integer.parseInt(req.getParameter("keyOrdinal"));
        HollowHistoryView objectView = this.getObjectView(session, version, type, keyOrdinal);
        return objectView;
    }

    private HollowHistoryView getObjectView(HollowDiffSession session, long version, String type, int keyOrdinal) {
        HollowHistoryView objectView = (HollowHistoryView)session.getObjectView();
        if (objectView != null && objectView.getHistoricalVersion() == version && objectView.getType().equals(type) && objectView.getKeyOrdinal() == keyOrdinal) {
            return objectView;
        }
        HollowHistoricalState historicalState = this.historyUI.getHistory().getHistoricalState(version);
        HollowHistoricalStateTypeKeyOrdinalMapping typeMapping = historicalState.getKeyOrdinalMapping().getTypeMapping(type);
        int fromOrdinal = typeMapping.findRemovedOrdinal(keyOrdinal);
        int toOrdinal = typeMapping.findAddedOrdinal(keyOrdinal);
        HollowDiffViewRow rootRow = new HollowObjectDiffViewGenerator((HollowDataAccess)historicalState.getDataAccess(), (HollowDataAccess)historicalState.getDataAccess(), this.historyUI, type, fromOrdinal, toOrdinal).getHollowDiffViewRows();
        objectView = new HollowHistoryView(version, type, keyOrdinal, rootRow, this.historyUI.getExactRecordMatcher());
        objectView.resetView();
        session.setObjectView(objectView);
        return objectView;
    }
}

