/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.ui.jetty;

import com.netflix.hollow.ui.jetty.OptionalDependencyException;

public class AbstractOptionalDependencyHelper {
    protected AbstractOptionalDependencyHelper() {
    }

    protected boolean isDependencyAvailable(String dependency) {
        try {
            Class.forName(dependency);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected Object newFactory(String factory, String dependency, String message) {
        try {
            if (!this.isDependencyAvailable(dependency)) {
                throw new OptionalDependencyException(message);
            }
            return Class.forName(factory).newInstance();
        }
        catch (OptionalDependencyException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OptionalDependencyException(message, ex);
        }
    }
}

