/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.model;

import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.history.ui.model.RecordDiff;
import com.netflix.hollow.history.ui.model.RecordDiffTreeNode;
import com.netflix.hollow.history.ui.naming.HollowHistoryRecordNamer;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import com.netflix.hollow.tools.history.keyindex.HollowHistoricalStateTypeKeyOrdinalMapping;
import java.util.Arrays;

public class HistoryStateTypeChanges {
    private final long stateVersion;
    private final String typeName;
    private final String[] groupedFieldNames;
    private final RecordDiffTreeNode modifiedRecords;
    private final RecordDiffTreeNode addedRecords;
    private final RecordDiffTreeNode removedRecords;

    public HistoryStateTypeChanges(HollowHistoricalState historicalState, String typeName, HollowHistoryRecordNamer recordNamer, String ... groupedFieldNames) {
        this.stateVersion = historicalState.getVersion();
        this.typeName = typeName;
        this.groupedFieldNames = groupedFieldNames;
        this.modifiedRecords = new RecordDiffTreeNode("", "Modified", "Modified", historicalState, recordNamer);
        this.addedRecords = new RecordDiffTreeNode("", "Added", "Added", historicalState, recordNamer);
        this.removedRecords = new RecordDiffTreeNode("", "Removed", "Removed", historicalState, recordNamer);
        HollowHistoricalStateTypeKeyOrdinalMapping typeKeyMapping = (HollowHistoricalStateTypeKeyOrdinalMapping)historicalState.getKeyOrdinalMapping().getTypeMappings().get(typeName);
        HollowObjectTypeDataAccess dataAccess = (HollowObjectTypeDataAccess)historicalState.getDataAccess().getTypeDataAccess(typeName);
        int[] groupedFieldIndexes = this.getGroupedFieldIndexes(groupedFieldNames, typeKeyMapping.getKeyIndex().getKeyFields());
        IntMap.IntMapEntryIterator removedIter = typeKeyMapping.removedOrdinalMappingIterator();
        IntMap.IntMapEntryIterator addedIter = typeKeyMapping.addedOrdinalMappingIterator();
        while (removedIter.next()) {
            int fromOrdinal = removedIter.getValue();
            int toOrdinal = typeKeyMapping.findAddedOrdinal(removedIter.getKey());
            if (toOrdinal != -1) {
                this.addRecordDiff(this.modifiedRecords, historicalState, typeKeyMapping, recordNamer, dataAccess, removedIter.getKey(), fromOrdinal, toOrdinal, groupedFieldIndexes);
                continue;
            }
            this.addRecordDiff(this.removedRecords, historicalState, typeKeyMapping, recordNamer, dataAccess, removedIter.getKey(), fromOrdinal, toOrdinal, groupedFieldIndexes);
        }
        while (addedIter.next()) {
            if (typeKeyMapping.findRemovedOrdinal(addedIter.getKey()) != -1) continue;
            int toOrdinal = addedIter.getValue();
            this.addRecordDiff(this.addedRecords, historicalState, typeKeyMapping, recordNamer, dataAccess, addedIter.getKey(), -1, toOrdinal, groupedFieldIndexes);
        }
    }

    private void addRecordDiff(RecordDiffTreeNode node, HollowHistoricalState historicalState, HollowHistoricalStateTypeKeyOrdinalMapping typeKeyMapping, HollowHistoryRecordNamer recordNamer, HollowObjectTypeDataAccess dataAccess, int keyOrdinal, int fromOrdinal, int toOrdinal, int[] fieldGroupIndexes) {
        for (int i = 0; i < fieldGroupIndexes.length; ++i) {
            node = node.getChildNode(typeKeyMapping.getKeyIndex().getKeyFieldValue(fieldGroupIndexes[i], keyOrdinal), fieldGroupIndexes[i]);
        }
        node.addRecordDiff(new RecordDiff(historicalState, recordNamer, typeKeyMapping, dataAccess, keyOrdinal, fromOrdinal, toOrdinal));
    }

    public long getStateVersion() {
        return this.stateVersion;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String[] getGroupedFieldNames() {
        return this.groupedFieldNames;
    }

    public RecordDiffTreeNode getModifiedRecords() {
        return this.modifiedRecords;
    }

    public RecordDiffTreeNode getAddedRecords() {
        return this.addedRecords;
    }

    public RecordDiffTreeNode getRemovedRecords() {
        return this.removedRecords;
    }

    public boolean isEmpty() {
        return this.modifiedRecords.isEmpty() && this.addedRecords.isEmpty() && this.removedRecords.isEmpty();
    }

    private int[] getGroupedFieldIndexes(String[] groupedFieldNames, String[] keyFields) {
        int[] groupedFieldIndexes = new int[groupedFieldNames.length];
        Arrays.fill(groupedFieldIndexes, -1);
        for (int i = 0; i < groupedFieldNames.length; ++i) {
            for (int j = 0; j < keyFields.length; ++j) {
                if (!groupedFieldNames[i].equals(keyFields[j])) continue;
                groupedFieldIndexes[i] = j;
            }
        }
        return groupedFieldIndexes;
    }

    public RecordDiffTreeNode findTreeNode(String hierarchicalFieldName) {
        RecordDiffTreeNode node = this.findTreeNode(this.modifiedRecords, hierarchicalFieldName);
        if (node != null) {
            return node;
        }
        node = this.findTreeNode(this.addedRecords, hierarchicalFieldName);
        if (node != null) {
            return node;
        }
        return this.findTreeNode(this.removedRecords, hierarchicalFieldName);
    }

    private RecordDiffTreeNode findTreeNode(RecordDiffTreeNode treeNode, String hierarchicalFieldName) {
        if (treeNode.getHierarchicalFieldName().equals(hierarchicalFieldName)) {
            return treeNode;
        }
        for (RecordDiffTreeNode child : treeNode.getSubGroups()) {
            RecordDiffTreeNode matchedDescendent = this.findTreeNode(child, hierarchicalFieldName);
            if (matchedDescendent == null) continue;
            return matchedDescendent;
        }
        return null;
    }
}

