/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.history.ui.model;

import com.netflix.hollow.tools.history.keyindex.HollowHistoricalStateTypeKeyOrdinalMapping;

public class HistoryStateTypeChangeSummary {
    private final long stateVersion;
    private final String typeName;
    private final int modifications;
    private final int additions;
    private final int removals;

    public HistoryStateTypeChangeSummary(long stateVersion, String typeName, HollowHistoricalStateTypeKeyOrdinalMapping mapping) {
        this.stateVersion = stateVersion;
        this.typeName = typeName;
        this.modifications = mapping.getNumberOfModifiedRecords();
        this.additions = mapping.getNumberOfNewRecords();
        this.removals = mapping.getNumberOfRemovedRecords();
    }

    public long getVersion() {
        return this.stateVersion;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getTotalChanges() {
        return this.modifications + this.additions + this.removals;
    }

    public int getModifications() {
        return this.modifications;
    }

    public int getAdditions() {
        return this.additions;
    }

    public int getRemovals() {
        return this.removals;
    }

    public boolean isEmpty() {
        return this.modifications == 0 && this.additions == 0 && this.removals == 0;
    }
}

