/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview.effigy.pairer;

import com.netflix.hollow.diffview.effigy.HollowEffigy;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyDiffRecord;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyFieldPairer;
import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class HollowEffigyCollectionPairer
extends HollowEffigyFieldPairer {
    private static final long[] EMPTY_DIFF_MATRIX = new long[0];
    static final int MAX_MATRIX_ELEMENT_FIELD_VALUE = 0x1FFFFF;
    private final long deadlineBeforePairingTimeout;

    public HollowEffigyCollectionPairer(HollowEffigy fromCollection, HollowEffigy toCollection, long deadlineBeforePairingTimeout) {
        super(fromCollection, toCollection);
        this.deadlineBeforePairingTimeout = deadlineBeforePairingTimeout;
    }

    @Override
    public List<HollowEffigyFieldPairer.EffigyFieldPair> pair() {
        int i;
        ArrayList<HollowEffigyFieldPairer.EffigyFieldPair> fieldPairs = new ArrayList<HollowEffigyFieldPairer.EffigyFieldPair>();
        BitSet pairedFromIndices = new BitSet(this.from.getFields().size());
        BitSet pairedToIndices = new BitSet(this.to.getFields().size());
        int[] maxDiffBackoff = new int[]{1, 2, 4, 8, Integer.MAX_VALUE};
        int maxPairs = Math.min(this.from.getFields().size(), this.to.getFields().size());
        block0: for (i = 0; i < maxDiffBackoff.length && fieldPairs.size() < maxPairs && System.currentTimeMillis() < this.deadlineBeforePairingTimeout; ++i) {
            long[] diffMatrixElements = this.pair(pairedFromIndices, pairedToIndices, maxDiffBackoff[i]);
            Arrays.sort(diffMatrixElements);
            for (long matrixElement : diffMatrixElements) {
                int diffScore;
                if (fieldPairs.size() == maxPairs || (diffScore = this.getDiffScore(matrixElement)) == 0x1FFFFF) continue block0;
                int fromIndex = this.getFromIndex(matrixElement);
                int toIndex = this.getToIndex(matrixElement);
                if (pairedFromIndices.get(fromIndex) || pairedToIndices.get(toIndex)) continue;
                fieldPairs.add(new HollowEffigyFieldPairer.EffigyFieldPair(this.from.getFields().get(fromIndex), this.to.getFields().get(toIndex), fromIndex, toIndex));
                pairedFromIndices.set(fromIndex);
                pairedToIndices.set(toIndex);
            }
        }
        if (System.currentTimeMillis() > this.deadlineBeforePairingTimeout) {
            HollowEffigy.Field fromField = new HollowEffigy.Field(new HollowDiffNodeIdentifier("TRUNCATED"), "PAIRING TIMEOUT");
            HollowEffigy.Field toField = new HollowEffigy.Field(new HollowDiffNodeIdentifier("TRUNCATED"), "ROWS OMITTED");
            fieldPairs.add(new HollowEffigyFieldPairer.EffigyFieldPair(fromField, toField, -1, -1));
        } else {
            for (i = 0; i < this.from.getFields().size(); ++i) {
                if (pairedFromIndices.get(i)) continue;
                fieldPairs.add(new HollowEffigyFieldPairer.EffigyFieldPair(this.from.getFields().get(i), null, i, -1));
            }
            for (i = 0; i < this.to.getFields().size(); ++i) {
                if (pairedToIndices.get(i)) continue;
                fieldPairs.add(new HollowEffigyFieldPairer.EffigyFieldPair(null, this.to.getFields().get(i), -1, i));
            }
        }
        return fieldPairs;
    }

    public long[] pair(BitSet pairedFromIndices, BitSet pairedToIndices, int maxDiff) {
        if (System.currentTimeMillis() > this.deadlineBeforePairingTimeout) {
            return EMPTY_DIFF_MATRIX;
        }
        long[] diffMatrixElements = new long[this.from.getFields().size() * this.to.getFields().size()];
        int matrixElementIdx = 0;
        for (int i = 0; i < this.from.getFields().size(); ++i) {
            int fromIdx = i;
            if (pairedFromIndices.get(fromIdx)) {
                for (int j = 0; j < this.to.getFields().size(); ++j) {
                    diffMatrixElements[matrixElementIdx++] = this.getDiffMatrixElement(fromIdx, j, 0x1FFFFF);
                }
                continue;
            }
            HollowEffigy fromElement = this.getComparisonEffigy((HollowEffigy)this.from.getFields().get(fromIdx).getValue());
            HollowEffigyDiffRecord diffRecord = new HollowEffigyDiffRecord(fromElement);
            for (int j = 0; j < this.to.getFields().size(); ++j) {
                if (pairedToIndices.get(j) || System.currentTimeMillis() > this.deadlineBeforePairingTimeout) {
                    diffMatrixElements[matrixElementIdx++] = this.getDiffMatrixElement(fromIdx, j, 0x1FFFFF);
                    continue;
                }
                HollowEffigy toElement = this.getComparisonEffigy((HollowEffigy)this.to.getFields().get(j).getValue());
                int diffScore = diffRecord.calculateDiff(toElement, maxDiff);
                diffMatrixElements[matrixElementIdx++] = this.getDiffMatrixElement(fromIdx, j, diffScore);
            }
        }
        return diffMatrixElements;
    }

    protected HollowEffigy getComparisonEffigy(HollowEffigy effigy) {
        return effigy;
    }

    private long getDiffMatrixElement(int fromIndex, int toIndex, int diffScore) {
        return (long)diffScore << 42 | (long)fromIndex << 21 | (long)toIndex;
    }

    private int getDiffScore(long diffMatrixElement) {
        return (int)(diffMatrixElement >> 42 & 0x1FFFFFL);
    }

    private int getFromIndex(long diffMatrixElement) {
        return (int)(diffMatrixElement >> 21 & 0x1FFFFFL);
    }

    private int getToIndex(long diffMatrixElement) {
        return (int)(diffMatrixElement & 0x1FFFFFL);
    }
}

