/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui.pages;

import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.diff.ui.HollowDiffSession;
import com.netflix.hollow.diff.ui.HollowDiffUI;
import com.netflix.hollow.diff.ui.model.HollowDiffUIBreadcrumbs;
import com.netflix.hollow.diff.ui.model.HollowFieldDiffScore;
import com.netflix.hollow.diff.ui.model.HollowObjectPairDiffScore;
import com.netflix.hollow.diff.ui.model.HollowUnmatchedObject;
import com.netflix.hollow.diff.ui.pages.DiffPage;
import com.netflix.hollow.tools.diff.HollowTypeDiff;
import com.netflix.hollow.tools.diff.count.HollowFieldDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.VelocityContext;

public class DiffTypePage
extends DiffPage {
    private final ConcurrentHashMap<String, List<HollowObjectPairDiffScore>> typeObjectPairScores = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<HollowUnmatchedObject>> unmatchedFromObjects = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<HollowUnmatchedObject>> unmatchedToObjects = new ConcurrentHashMap();

    public DiffTypePage(HollowDiffUI diffUI) {
        super(diffUI, "diff-type.vm");
    }

    @Override
    protected void setUpContext(HttpServletRequest req, HollowDiffSession session, VelocityContext ctx) {
        String typeName = req.getParameter("type");
        HollowTypeDiff typeDiff = this.getTypeDiff(typeName);
        int diffPairBeginIdx = this.intParam(req, session, typeName, "diffPairBeginIdx", 0);
        int diffPairPageSize = this.intParam(req, session, typeName, "diffPairPageSize", 25);
        int unmatchedFromBeginIdx = this.intParam(req, session, typeName, "unmatchedFromBeginIdx", 0);
        int unmatchedToBeginIdx = this.intParam(req, session, typeName, "unmatchedToBeginIdx", 0);
        int unmatchedPageSize = this.intParam(req, session, typeName, "unmatchedPageSize", 25);
        boolean showFields = this.boolParam(req, session, typeName, "showFields", true);
        List<HollowObjectPairDiffScore> pairs = this.lazyGetDiffScorePairs(typeDiff);
        List<HollowUnmatchedObject> unmatchedFrom = this.lazyGetUnmatchedFromObjects(typeDiff);
        List<HollowUnmatchedObject> unmatchedTo = this.lazyGetUnmatchedToObjects(typeDiff);
        ctx.put("objectScorePairs", this.sublist(pairs, diffPairBeginIdx, diffPairPageSize));
        ctx.put("unmatchedFromObjects", this.sublist(unmatchedFrom, unmatchedFromBeginIdx, unmatchedPageSize));
        ctx.put("unmatchedToObjects", this.sublist(unmatchedTo, unmatchedToBeginIdx, unmatchedPageSize));
        ctx.put("typeDiff", (Object)typeDiff);
        ctx.put("fieldDiffs", this.getDisplayDiffs(typeDiff));
        ctx.put("numObjectsDiff", (Object)pairs.size());
        if (diffPairBeginIdx > 0) {
            ctx.put("previousDiffPairPageBeginIdx", (Object)(diffPairBeginIdx - diffPairPageSize));
        }
        if (diffPairBeginIdx + diffPairPageSize < pairs.size()) {
            ctx.put("nextDiffPairPageBeginIdx", (Object)(diffPairBeginIdx + diffPairPageSize));
        }
        if (unmatchedFromBeginIdx > 0) {
            ctx.put("previousUnmatchedFromPageBeginIdx", (Object)(unmatchedFromBeginIdx - unmatchedPageSize));
        }
        if (unmatchedFromBeginIdx + unmatchedPageSize < unmatchedFrom.size()) {
            ctx.put("nextUnmatchedFromPageBeginIdx", (Object)(unmatchedFromBeginIdx + unmatchedPageSize));
        }
        if (unmatchedToBeginIdx > 0) {
            ctx.put("previousUnmatchedToPageBeginIdx", (Object)(unmatchedToBeginIdx - unmatchedPageSize));
        }
        if (unmatchedToBeginIdx + unmatchedPageSize < unmatchedTo.size()) {
            ctx.put("nextUnmatchedToPageBeginIdx", (Object)(unmatchedToBeginIdx + unmatchedPageSize));
        }
        ctx.put("showFields", (Object)showFields);
        ctx.put("breadcrumbs", this.getBreadcrumbs(typeDiff));
    }

    private <T> List<T> sublist(List<T> list, int fromIndex, int pageSize) {
        if (fromIndex >= list.size()) {
            fromIndex = 0;
        }
        if (fromIndex + pageSize >= list.size()) {
            pageSize = list.size() - fromIndex;
        }
        return list.subList(fromIndex, fromIndex + pageSize);
    }

    private List<HollowFieldDiffScore> getDisplayDiffs(HollowTypeDiff typeDiff) {
        List fieldDiffs = typeDiff.getFieldDiffs();
        ArrayList<HollowFieldDiffScore> displayDiffs = new ArrayList<HollowFieldDiffScore>();
        for (int i = 0; i < fieldDiffs.size(); ++i) {
            HollowFieldDiff fieldDiff = (HollowFieldDiff)fieldDiffs.get(i);
            displayDiffs.add(new HollowFieldDiffScore(typeDiff.getTypeName(), i, fieldDiff.getFieldIdentifier().toString(), fieldDiff.getNumDiffs(), typeDiff.getTotalNumberOfMatches(), fieldDiff.getTotalDiffScore()));
        }
        Collections.sort(displayDiffs);
        return displayDiffs;
    }

    private List<HollowObjectPairDiffScore> lazyGetDiffScorePairs(HollowTypeDiff typeDiff) {
        List<HollowObjectPairDiffScore> scores = this.typeObjectPairScores.get(typeDiff.getTypeName());
        if (scores != null) {
            return scores;
        }
        scores = this.aggregateFieldDiffScores(typeDiff);
        List<HollowObjectPairDiffScore> existingScores = this.typeObjectPairScores.putIfAbsent(typeDiff.getTypeName(), scores);
        return existingScores != null ? existingScores : scores;
    }

    private List<HollowObjectPairDiffScore> aggregateFieldDiffScores(HollowTypeDiff typeDiff) {
        int maxFromOrdinal = typeDiff.getFromTypeState().maxOrdinal();
        HollowObjectPairDiffScore[] allDiffPairsIndexedByFromOrdinal = new HollowObjectPairDiffScore[maxFromOrdinal + 1];
        int diffPairCounts = 0;
        for (HollowFieldDiff fieldDiff : typeDiff.getFieldDiffs()) {
            for (int i = 0; i < fieldDiff.getNumDiffs(); ++i) {
                int fromOrdinal = fieldDiff.getFromOrdinal(i);
                if (allDiffPairsIndexedByFromOrdinal[fromOrdinal] == null) {
                    String displayKey = typeDiff.getMatcher().getKeyDisplayString(typeDiff.getFromTypeState(), fromOrdinal);
                    allDiffPairsIndexedByFromOrdinal[fromOrdinal] = new HollowObjectPairDiffScore(displayKey, fromOrdinal, fieldDiff.getToOrdinal(i));
                    ++diffPairCounts;
                }
                allDiffPairsIndexedByFromOrdinal[fromOrdinal].incrementDiffScore(fieldDiff.getPairScore(i));
            }
        }
        ArrayList<HollowObjectPairDiffScore> scores = new ArrayList<HollowObjectPairDiffScore>(diffPairCounts);
        for (HollowObjectPairDiffScore score : allDiffPairsIndexedByFromOrdinal) {
            if (score == null) continue;
            scores.add(score);
        }
        Collections.sort(scores);
        return scores;
    }

    private List<HollowUnmatchedObject> lazyGetUnmatchedFromObjects(HollowTypeDiff typeDiff) {
        return this.lazyGetUnmatchedObjects(this.unmatchedFromObjects, typeDiff, typeDiff.getFromTypeState(), typeDiff.getUnmatchedOrdinalsInFrom());
    }

    private List<HollowUnmatchedObject> lazyGetUnmatchedToObjects(HollowTypeDiff typeDiff) {
        return this.lazyGetUnmatchedObjects(this.unmatchedToObjects, typeDiff, typeDiff.getToTypeState(), typeDiff.getUnmatchedOrdinalsInTo());
    }

    private List<HollowUnmatchedObject> lazyGetUnmatchedObjects(ConcurrentHashMap<String, List<HollowUnmatchedObject>> cache, HollowTypeDiff typeDiff, HollowObjectTypeReadState typeState, IntList unmatchedOrdinals) {
        List<HollowUnmatchedObject> list = cache.get(typeDiff.getTypeName());
        if (list != null) {
            return list;
        }
        list = new ArrayList<HollowUnmatchedObject>();
        for (int i = 0; i < unmatchedOrdinals.size(); ++i) {
            int ordinal = unmatchedOrdinals.get(i);
            String keyDisplay = typeDiff.getMatcher().getKeyDisplayString(typeState, ordinal);
            list.add(new HollowUnmatchedObject(keyDisplay, ordinal));
        }
        List<HollowUnmatchedObject> existingList = cache.putIfAbsent(typeState.getSchema().getName(), list);
        return existingList != null ? existingList : list;
    }

    private List<HollowDiffUIBreadcrumbs> getBreadcrumbs(HollowTypeDiff typeDiff) {
        ArrayList<HollowDiffUIBreadcrumbs> breadcrumbs = new ArrayList<HollowDiffUIBreadcrumbs>();
        breadcrumbs.add(new HollowDiffUIBreadcrumbs(this.diffUI.getDiffUIPath(), "Overview"));
        breadcrumbs.add(new HollowDiffUIBreadcrumbs(null, typeDiff.getTypeName()));
        return breadcrumbs;
    }
}

