/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui;

import com.netflix.hollow.diffview.HollowObjectView;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HollowDiffSession {
    private static final long SESSION_ABANDONMENT_MILLIS = 3600000L;
    private final Map<String, Object> sessionParams = new ConcurrentHashMap<String, Object>();
    private HollowObjectView currentObjectView;
    private long lastAccessed;
    private static final ConcurrentHashMap<Long, HollowDiffSession> sessions = new ConcurrentHashMap();

    public void setAttribute(String param, Object value) {
        this.sessionParams.put(param, value);
    }

    public Object getAttribute(String param) {
        return this.sessionParams.get(param);
    }

    public void setObjectView(HollowObjectView view) {
        this.currentObjectView = view;
    }

    public HollowObjectView getObjectView() {
        return this.currentObjectView;
    }

    public void updateLastAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    public static HollowDiffSession getSession(HttpServletRequest req, HttpServletResponse resp) {
        HollowDiffSession existingSession;
        HollowDiffSession session;
        Long sessionId = null;
        if (req.getCookies() != null) {
            for (Cookie cookie : req.getCookies()) {
                if (!"hollowDiffSessionId".equals(cookie.getName())) continue;
                sessionId = Long.valueOf(cookie.getValue());
            }
        }
        if (sessionId == null) {
            sessionId = new Random().nextLong() & Long.MAX_VALUE;
            Cookie cookie = new Cookie("hollowDiffSessionId", sessionId.toString());
            cookie.setComment("__HTTP_ONLY__");
            resp.addCookie(cookie);
        }
        if ((session = sessions.get(sessionId)) == null && (existingSession = sessions.putIfAbsent(sessionId, session = new HollowDiffSession())) != null) {
            session = existingSession;
        }
        return session;
    }

    static {
        Thread sessionCleanupThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Iterator iter = sessions.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (((HollowDiffSession)entry.getValue()).lastAccessed + 3600000L >= System.currentTimeMillis()) continue;
                    iter.remove();
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        sessionCleanupThread.setDaemon(true);
        sessionCleanupThread.start();
    }
}

