/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diffview.effigy.pairer;

import com.netflix.hollow.diffview.effigy.HollowEffigy;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyCollectionPairer;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyMapPairer;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyNullPartnerPairer;
import com.netflix.hollow.diffview.effigy.pairer.HollowEffigyObjectPairer;
import java.util.List;

public abstract class HollowEffigyFieldPairer {
    protected final HollowEffigy from;
    protected final HollowEffigy to;

    public HollowEffigyFieldPairer(HollowEffigy from, HollowEffigy to) {
        this.from = from;
        this.to = to;
    }

    public abstract List<EffigyFieldPair> pair();

    public static List<EffigyFieldPair> pair(HollowEffigy from, HollowEffigy to, long deadlineBeforePairingTimeout) {
        if (from == null || to == null) {
            return new HollowEffigyNullPartnerPairer(from, to).pair();
        }
        if (from.getCollectionType() == HollowEffigy.CollectionType.NONE) {
            return new HollowEffigyObjectPairer(from, to).pair();
        }
        if (from.getCollectionType() == HollowEffigy.CollectionType.MAP) {
            return new HollowEffigyMapPairer(from, to, deadlineBeforePairingTimeout).pair();
        }
        return new HollowEffigyCollectionPairer(from, to, deadlineBeforePairingTimeout).pair();
    }

    public static class EffigyFieldPair {
        private final HollowEffigy.Field from;
        private final HollowEffigy.Field to;
        private final int fromIdx;
        private final int toIdx;
        private final boolean isDiff;

        public EffigyFieldPair(HollowEffigy.Field from, HollowEffigy.Field to, int fromIdx, int toIdx) {
            this.from = from;
            this.to = to;
            this.fromIdx = fromIdx;
            this.toIdx = toIdx;
            this.isDiff = this.calculateIsDiff();
        }

        private boolean calculateIsDiff() {
            if (this.from == null && this.to != null || this.from != null && this.to == null) {
                return true;
            }
            if (this.from.getValue() == null) {
                return this.to.getValue() != null;
            }
            if (this.isLeafNode()) {
                return !this.from.getValue().equals(this.to.getValue());
            }
            return false;
        }

        public HollowEffigy.Field getFrom() {
            return this.from;
        }

        public HollowEffigy.Field getTo() {
            return this.to;
        }

        public int getFromIdx() {
            return this.fromIdx;
        }

        public int getToIdx() {
            return this.toIdx;
        }

        public boolean isLeafNode() {
            return this.from != null && this.from.getValue() != null ? this.from.isLeafNode() : (this.to == null ? true : this.to.isLeafNode());
        }

        public boolean isDiff() {
            return this.isDiff;
        }
    }
}

