/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.diff.ui;

import com.netflix.hollow.diff.ui.HollowDiffSession;
import com.netflix.hollow.diff.ui.pages.DiffFieldPage;
import com.netflix.hollow.diff.ui.pages.DiffObjectPage;
import com.netflix.hollow.diff.ui.pages.DiffOverviewPage;
import com.netflix.hollow.diff.ui.pages.DiffPage;
import com.netflix.hollow.diff.ui.pages.DiffTypePage;
import com.netflix.hollow.diffview.DiffViewOutputGenerator;
import com.netflix.hollow.diffview.HollowDiffViewProvider;
import com.netflix.hollow.diffview.HollowObjectViewProvider;
import com.netflix.hollow.diffview.effigy.CustomHollowEffigyFactory;
import com.netflix.hollow.diffview.effigy.CustomHollowEffigyFactoryProvider;
import com.netflix.hollow.tools.diff.HollowDiff;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.app.VelocityEngine;

public class HollowDiffUI
implements CustomHollowEffigyFactoryProvider {
    private final String baseURLPath;
    private final String diffUIPath;
    private final HollowDiff diff;
    private final VelocityEngine velocity;
    private final String fromBlobName;
    private final String toBlobName;
    private final DiffOverviewPage overviewPage;
    private final DiffTypePage typePage;
    private final DiffFieldPage fieldPage;
    private final DiffObjectPage objectPage;
    private final HollowObjectViewProvider viewProvider;
    private final DiffViewOutputGenerator diffViewOutputGenerator;
    private final Map<String, CustomHollowEffigyFactory> customHollowEffigyFactories;

    HollowDiffUI(String baseURLPath, String diffUIPath, HollowDiff diff, String fromBlobName, String toBlobName, VelocityEngine ve) {
        this.baseURLPath = baseURLPath;
        this.diffUIPath = baseURLPath + "/" + diffUIPath;
        this.diff = diff;
        this.velocity = ve;
        this.fromBlobName = fromBlobName;
        this.toBlobName = toBlobName;
        this.overviewPage = new DiffOverviewPage(this);
        this.typePage = new DiffTypePage(this);
        this.fieldPage = new DiffFieldPage(this);
        this.objectPage = new DiffObjectPage(this);
        this.viewProvider = new HollowDiffViewProvider(this);
        this.diffViewOutputGenerator = new DiffViewOutputGenerator(this.viewProvider);
        this.customHollowEffigyFactories = new HashMap<String, CustomHollowEffigyFactory>();
    }

    public boolean serveRequest(String pageName, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if ("diffrowdata".equals(pageName)) {
            this.diffViewOutputGenerator.uncollapseRow(req, resp);
            return true;
        }
        if ("collapsediffrow".equals(pageName)) {
            this.diffViewOutputGenerator.collapseRow(req, resp);
            return true;
        }
        resp.setContentType("text/html");
        if ("".equals(pageName) || "overview".equals(pageName)) {
            this.render(this.overviewPage, req, resp);
        } else if ("typediff".equals(pageName)) {
            this.render(this.typePage, req, resp);
        } else if ("fielddiff".equals(pageName)) {
            this.render(this.fieldPage, req, resp);
        } else if ("objectdiff".equals(pageName)) {
            this.render(this.objectPage, req, resp);
        } else {
            return false;
        }
        return true;
    }

    public HollowDiff getDiff() {
        return this.diff;
    }

    public String getFromBlobName() {
        return this.fromBlobName;
    }

    public String getToBlobName() {
        return this.toBlobName;
    }

    public VelocityEngine getVelocity() {
        return this.velocity;
    }

    public String getBaseURLPath() {
        return this.baseURLPath;
    }

    public String getDiffUIPath() {
        return this.diffUIPath;
    }

    public void addCustomHollowEffigyFactory(String typeName, CustomHollowEffigyFactory factory) {
        this.customHollowEffigyFactories.put(typeName, factory);
    }

    @Override
    public CustomHollowEffigyFactory getCustomHollowEffigyFactory(String typeName) {
        return this.customHollowEffigyFactories.get(typeName);
    }

    public HollowObjectViewProvider getHollowObjectViewProvider() {
        return this.viewProvider;
    }

    public DiffViewOutputGenerator getDiffViewOutputGenerator() {
        return this.diffViewOutputGenerator;
    }

    private void render(DiffPage page, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        page.render(req, HollowDiffSession.getSession(req, resp), resp.getWriter());
    }
}

