/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLClients;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import com.netflix.graphql.dgs.client.MonoGraphQLClient;
import com.netflix.graphql.dgs.client.Request;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/graphql/dgs/client/WebClientGraphQLClient;", "Lcom/netflix/graphql/dgs/client/MonoGraphQLClient;", "webclient", "Lorg/springframework/web/reactive/function/client/WebClient;", "(Lorg/springframework/web/reactive/function/client/WebClient;)V", "headersConsumer", "Ljava/util/function/Consumer;", "Lorg/springframework/http/HttpHeaders;", "(Lorg/springframework/web/reactive/function/client/WebClient;Ljava/util/function/Consumer;)V", "handleResponse", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "response", "Lcom/netflix/graphql/dgs/client/HttpResponse;", "requestBody", "", "reactiveExecuteQuery", "Lreactor/core/publisher/Mono;", "query", "variables", "", "", "operationName", "graphql-dgs-client"})
public final class WebClientGraphQLClient
implements MonoGraphQLClient {
    @NotNull
    private final WebClient webclient;
    @NotNull
    private final Consumer<HttpHeaders> headersConsumer;

    public WebClientGraphQLClient(@NotNull WebClient webclient, @NotNull Consumer<HttpHeaders> headersConsumer) {
        Intrinsics.checkNotNullParameter((Object)webclient, (String)"webclient");
        Intrinsics.checkNotNullParameter(headersConsumer, (String)"headersConsumer");
        this.webclient = webclient;
        this.headersConsumer = headersConsumer;
    }

    public WebClientGraphQLClient(@NotNull WebClient webclient) {
        Intrinsics.checkNotNullParameter((Object)webclient, (String)"webclient");
        this(webclient, WebClientGraphQLClient::_init_$lambda-0);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.reactiveExecuteQuery(query, (Map<String, ? extends Object>)MapsKt.emptyMap(), (String)null);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return this.reactiveExecuteQuery(query, variables, (String)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        void $this$toEntity$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        String serializedRequest = GraphQLClients.INSTANCE.getObjectMapper$graphql_dgs_client().writeValueAsString((Object)new Request(query, variables, operationName));
        WebClient.ResponseSpec responseSpec = this.webclient.post().bodyValue((Object)serializedRequest).headers(WebClientGraphQLClient::reactiveExecuteQuery$lambda-1).headers(this.headersConsumer).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"webclient.post()\n       \u2026)\n            .retrieve()");
        WebClient.ResponseSpec responseSpec2 = responseSpec;
        boolean $i$f$toEntity = false;
        Mono mono = $this$toEntity$iv.toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<String>(){});
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"toEntity(object : Parame\u2026zedTypeReference<T>() {})");
        Mono mono2 = mono.map(WebClientGraphQLClient::reactiveExecuteQuery$lambda-2).map(arg_0 -> WebClientGraphQLClient.reactiveExecuteQuery$lambda-3(this, serializedRequest, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"webclient.post()\n       \u2026nse, serializedRequest) }");
        return mono2;
    }

    private final GraphQLResponse handleResponse(HttpResponse response, String requestBody) {
        int statusCode = response.component1();
        String body = response.component2();
        Map<String, List<String>> headers = response.getHeaders();
        if (!HttpStatus.valueOf((int)statusCode).is2xxSuccessful()) {
            String string = this.webclient.toString();
            String string2 = body;
            if (string2 == null) {
                string2 = "";
            }
            throw new GraphQLClientException(statusCode, string, string2, requestBody);
        }
        String string = body;
        if (string == null) {
            string = "";
        }
        return new GraphQLResponse(string, headers);
    }

    private static final void _init_$lambda-0(HttpHeaders it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final void reactiveExecuteQuery$lambda-1(HttpHeaders headers) {
        headers.addAll((MultiValueMap)GraphQLClients.INSTANCE.getDefaultHeaders$graphql_dgs_client());
    }

    private static final HttpResponse reactiveExecuteQuery$lambda-2(ResponseEntity response) {
        int n = response.getStatusCodeValue();
        String string = (String)response.getBody();
        HttpHeaders httpHeaders = response.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"response.headers");
        return new HttpResponse(n, string, (Map)httpHeaders);
    }

    private static final GraphQLResponse reactiveExecuteQuery$lambda-3(WebClientGraphQLClient this$0, String $serializedRequest, HttpResponse httpResponse) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"httpResponse");
        Intrinsics.checkNotNullExpressionValue((Object)$serializedRequest, (String)"serializedRequest");
        return this$0.handleResponse(httpResponse, $serializedRequest);
    }
}

