/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.netflix.graphql.dgs.client.GraphQLError;
import com.netflix.graphql.dgs.client.RequestDetails;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u001f\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0019\u0010!\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\"\u001a\u00020\u0003\u00a2\u0006\u0002\u0010#J'\u0010$\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\"\u001a\u00020\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u001a0&\u00a2\u0006\u0002\u0010'J'\u0010$\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\"\u001a\u00020\u00032\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020\u001fJ\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "", "json", "", "(Ljava/lang/String;)V", "data", "", "getData", "()Ljava/util/Map;", "errors", "", "Lcom/netflix/graphql/dgs/client/GraphQLError;", "getErrors", "()Ljava/util/List;", "getJson", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "parsed", "Lcom/jayway/jsonpath/DocumentContext;", "getParsed", "()Lcom/jayway/jsonpath/DocumentContext;", "component1", "copy", "dataAsObject", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "equals", "", "other", "extractValue", "path", "(Ljava/lang/String;)Ljava/lang/Object;", "extractValueAsObject", "typeRef", "Lcom/jayway/jsonpath/TypeRef;", "(Ljava/lang/String;Lcom/jayway/jsonpath/TypeRef;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getDataPath", "getRequestDetails", "Lcom/netflix/graphql/dgs/client/RequestDetails;", "hasErrors", "hashCode", "", "toString", "Companion", "graphql-dgs-client"})
public final class GraphQLResponse {
    @NotNull
    private final DocumentContext parsed;
    @NotNull
    private final Map<String, Object> data;
    @NotNull
    private final List<GraphQLError> errors;
    private final Logger logger;
    @NotNull
    private final String json;
    private static final ObjectMapper mapper;
    private static final Configuration jsonPathConfig;
    public static final Companion Companion;

    @NotNull
    public final DocumentContext getParsed() {
        return this.parsed;
    }

    @NotNull
    public final Map<String, Object> getData() {
        return this.data;
    }

    @NotNull
    public final List<GraphQLError> getErrors() {
        return this.errors;
    }

    public final <T> T dataAsObject(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)mapper.convertValue(this.data, clazz);
    }

    public final <T> T extractValue(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String dataPath = this.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, new Predicate[0]);
        }
        catch (Exception ex) {
            this.logger.error("Error extracting path '" + path + "' from data: '" + this.data + '\'');
            throw (Throwable)ex;
        }
    }

    public final <T> T extractValueAsObject(@NotNull String path, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String dataPath = this.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, clazz, new Predicate[0]);
        }
        catch (Exception ex) {
            this.logger.error("Error extracting path '" + path + "' from data: '" + this.data + '\'');
            throw (Throwable)ex;
        }
    }

    public final <T> T extractValueAsObject(@NotNull String path, @NotNull TypeRef<T> typeRef) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(typeRef, (String)"typeRef");
        String dataPath = this.getDataPath(path);
        try {
            return (T)this.parsed.read(dataPath, typeRef);
        }
        catch (Exception ex) {
            this.logger.error("Error extracting path '" + path + "' from data: '" + this.data + '\'');
            throw (Throwable)ex;
        }
    }

    @NotNull
    public final RequestDetails getRequestDetails() {
        return this.extractValueAsObject("gatewayRequestDetails", RequestDetails.class);
    }

    private final String getDataPath(String path) {
        return !StringsKt.startsWith$default((String)path, (String)"data", (boolean)false, (int)2, null) ? "data." + path : path;
    }

    public final boolean hasErrors() {
        Collection collection = this.errors;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @NotNull
    public final String getJson() {
        return this.json;
    }

    public GraphQLResponse(@NotNull String json) {
        List list;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.json = json;
        DocumentContext documentContext = JsonPath.using((Configuration)jsonPathConfig).parse(this.json);
        Intrinsics.checkNotNullExpressionValue((Object)documentContext, (String)"JsonPath.using(jsonPathConfig).parse(json)");
        this.parsed = documentContext;
        Map map = (Map)this.parsed.read("data", new Predicate[0]);
        if (map == null) {
            map = this.data = MapsKt.emptyMap();
        }
        if ((list = (List)this.parsed.read("errors", (TypeRef)new TypeRef<List<? extends GraphQLError>>(){})) == null) {
            list = CollectionsKt.emptyList();
        }
        this.errors = list;
        this.logger = LoggerFactory.getLogger(GraphQLResponse.class);
    }

    static {
        Companion = new Companion(null);
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new JavaTimeModule()).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"jacksonObjectMapper()\n  \u2026LUES_USING_DEFAULT_VALUE)");
        mapper = objectMapper;
        Configuration configuration = Configuration.defaultConfiguration().jsonProvider((JsonProvider)new JacksonJsonProvider(mapper)).mappingProvider((MappingProvider)new JacksonMappingProvider(mapper)).addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"Configuration.defaultCon\u2026EFAULT_PATH_LEAF_TO_NULL)");
        jsonPathConfig = configuration;
    }

    @NotNull
    public final String component1() {
        return this.json;
    }

    @NotNull
    public final GraphQLResponse copy(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return new GraphQLResponse(json);
    }

    public static /* synthetic */ GraphQLResponse copy$default(GraphQLResponse graphQLResponse, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = graphQLResponse.json;
        }
        return graphQLResponse.copy(string);
    }

    @NotNull
    public String toString() {
        return "GraphQLResponse(json=" + this.json + ")";
    }

    public int hashCode() {
        String string = this.json;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GraphQLResponse)) break block3;
                GraphQLResponse graphQLResponse = (GraphQLResponse)object;
                if (!Intrinsics.areEqual((Object)this.json, (Object)graphQLResponse.json)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/client/GraphQLResponse$Companion;", "", "()V", "jsonPathConfig", "Lcom/jayway/jsonpath/Configuration;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

