/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.netflix.graphql.dgs.client.GraphQLClient;
import com.netflix.graphql.dgs.client.GraphQLClientException;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.HttpResponse;
import com.netflix.graphql.dgs.client.MonoGraphQLClient;
import com.netflix.graphql.dgs.client.MonoRequestExecutor;
import com.netflix.graphql.dgs.client.RequestExecutor;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/netflix/graphql/dgs/client/DefaultGraphQLClient;", "Lcom/netflix/graphql/dgs/client/GraphQLClient;", "Lcom/netflix/graphql/dgs/client/MonoGraphQLClient;", "url", "", "(Ljava/lang/String;)V", "executeQuery", "Lcom/netflix/graphql/dgs/client/GraphQLResponse;", "query", "variables", "", "", "requestExecutor", "Lcom/netflix/graphql/dgs/client/RequestExecutor;", "handleResponse", "response", "Lcom/netflix/graphql/dgs/client/HttpResponse;", "requestBody", "reactiveExecuteQuery", "Lreactor/core/publisher/Mono;", "Lcom/netflix/graphql/dgs/client/MonoRequestExecutor;", "Companion", "graphql-dgs-client"})
public final class DefaultGraphQLClient
implements GraphQLClient,
MonoGraphQLClient {
    private final String url;
    private static final ObjectMapper objectMapper;
    private static final Map<String, List<String>> defaultHeaders;
    public static final Companion Companion;

    @Override
    @NotNull
    public GraphQLResponse executeQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @NotNull RequestExecutor requestExecutor) {
        String serializedRequest;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        String string = serializedRequest = objectMapper.writeValueAsString((Object)new Companion.Request(query, variables));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializedRequest");
        HttpResponse response = requestExecutor.execute(this.url, defaultHeaders, string);
        return this.handleResponse(response, serializedRequest);
    }

    @Override
    @NotNull
    public Mono<GraphQLResponse> reactiveExecuteQuery(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @NotNull MonoRequestExecutor requestExecutor) {
        String serializedRequest;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        String string = serializedRequest = objectMapper.writeValueAsString((Object)new Companion.Request(query, variables));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializedRequest");
        Mono mono = requestExecutor.execute(this.url, defaultHeaders, string).map((Function)new Function<HttpResponse, GraphQLResponse>(this, serializedRequest){
            final /* synthetic */ DefaultGraphQLClient this$0;
            final /* synthetic */ String $serializedRequest;

            public final GraphQLResponse apply(HttpResponse response) {
                HttpResponse httpResponse = response;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"response");
                String string = this.$serializedRequest;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializedRequest");
                return DefaultGraphQLClient.access$handleResponse(this.this$0, httpResponse, string);
            }
            {
                this.this$0 = defaultGraphQLClient;
                this.$serializedRequest = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"requestExecutor.execute(\u2026ializedRequest)\n        }");
        return mono;
    }

    /*
     * WARNING - void declaration
     */
    private final GraphQLResponse handleResponse(HttpResponse response, String requestBody) {
        void statusCode;
        HttpResponse httpResponse = response;
        int n = httpResponse.component1();
        String body = httpResponse.component2();
        void var5_4 = statusCode;
        if (200 > var5_4 || 299 < var5_4) {
            String string = body;
            if (string == null) {
                string = "";
            }
            throw (Throwable)new GraphQLClientException((int)statusCode, this.url, string, requestBody);
        }
        String string = body;
        if (string == null) {
            string = "";
        }
        return new GraphQLResponse(string);
    }

    public DefaultGraphQLClient(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    static {
        ObjectMapper objectMapper;
        Companion = new Companion(null);
        try {
            Class.forName("com.fasterxml.jackson.module.kotlin.KotlinModule$Builder");
            ObjectMapper objectMapper2 = new ObjectMapper().registerModule((Module)new KotlinModule.Builder().nullIsSameAsDefault(true).build());
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"ObjectMapper().registerM\u2026eAsDefault(true).build())");
            objectMapper = objectMapper2;
        }
        catch (ClassNotFoundException ex) {
            objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
        }
        DefaultGraphQLClient.objectMapper = objectMapper;
        defaultHeaders = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Accept", (Object)CollectionsKt.listOf((Object)"application/json")), TuplesKt.to((Object)"Content-type", (Object)CollectionsKt.listOf((Object)"application/json"))});
    }

    public static final /* synthetic */ GraphQLResponse access$handleResponse(DefaultGraphQLClient $this, HttpResponse response, String requestBody) {
        return $this.handleResponse(response, requestBody);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/client/DefaultGraphQLClient$Companion;", "", "()V", "defaultHeaders", "", "", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "Request", "graphql-dgs-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/netflix/graphql/dgs/client/DefaultGraphQLClient$Companion$Request;", "", "query", "", "variables", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getQuery", "()Ljava/lang/String;", "getVariables", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs-client"})
        private static final class Request {
            @NotNull
            private final String query;
            @NotNull
            private final Map<String, Object> variables;

            @NotNull
            public final String getQuery() {
                return this.query;
            }

            @NotNull
            public final Map<String, Object> getVariables() {
                return this.variables;
            }

            public Request(@NotNull String query, @NotNull Map<String, ? extends Object> variables) {
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                this.query = query;
                this.variables = variables;
            }

            @NotNull
            public final String component1() {
                return this.query;
            }

            @NotNull
            public final Map<String, Object> component2() {
                return this.variables;
            }

            @NotNull
            public final Request copy(@NotNull String query, @NotNull Map<String, ? extends Object> variables) {
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                return new Request(query, variables);
            }

            public static /* synthetic */ Request copy$default(Request request, String string, Map map, int n, Object object) {
                if ((n & 1) != 0) {
                    string = request.query;
                }
                if ((n & 2) != 0) {
                    map = request.variables;
                }
                return request.copy(string, map);
            }

            @NotNull
            public String toString() {
                return "Request(query=" + this.query + ", variables=" + this.variables + ")";
            }

            public int hashCode() {
                String string = this.query;
                Map<String, Object> map = this.variables;
                return (string != null ? string.hashCode() : 0) * 31 + (map != null ? ((Object)map).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Request)) break block3;
                        Request request = (Request)object;
                        if (!Intrinsics.areEqual((Object)this.query, (Object)request.query) || !Intrinsics.areEqual(this.variables, request.variables)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

