/*
 * Copyright 2020 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.netflix.graphql.dgs.client.codegen

import java.util.*

abstract class BaseProjectionNode {
    val fields: MutableMap<String, Any?> = LinkedHashMap()
    val fragments: MutableList<BaseSubProjectionNode<*, *>> = LinkedList()

    override fun toString(): String {
        if (fields.isEmpty() && fragments.isEmpty()) {
            return ""
        }

        val joiner = StringJoiner(" ", "{ ", " }")
        fields.forEach { (key, value) ->
            joiner.add(key)
            if (value != null) {
                joiner.add(" ").add(value.toString())
            }
        }

        fragments.forEach { joiner.add(it.toString()) }

        return joiner.toString()
    }
}