/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.netflix.governator.guice.LifecycleInjector;
import com.netflix.governator.guice.LifecycleInjectorBuilder;
import com.netflix.governator.guice.LifecycleInjectorBuilderSuite;
import com.netflix.governator.lifecycle.LifecycleManager;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class LifecycleTester
extends ExternalResource {
    private LifecycleInjectorBuilderSuite[] suites;
    private Injector injector;
    private Class<?> bootstrap;
    private LifecycleInjectorBuilder builder;

    public LifecycleTester(List<LifecycleInjectorBuilderSuite> suites) {
        this.suites = suites.toArray(new LifecycleInjectorBuilderSuite[suites.size()]);
    }

    public LifecycleTester(LifecycleInjectorBuilderSuite ... suites) {
        this.suites = suites;
    }

    public LifecycleTester(Class bootstrap, LifecycleInjectorBuilderSuite ... suites) {
        this.bootstrap = bootstrap;
        this.suites = suites;
    }

    public Injector start() {
        if (this.bootstrap != null) {
            this.injector = LifecycleInjector.bootstrap(this.bootstrap, (LifecycleInjectorBuilderSuite[])this.suites);
        } else {
            this.builder = LifecycleInjector.builder();
            this.builder = LifecycleInjector.builder();
            if (this.suites != null) {
                for (LifecycleInjectorBuilderSuite suite : this.suites) {
                    suite.configure(this.builder);
                }
            }
            this.injector = this.builder.build().createInjector();
        }
        LifecycleManager manager = (LifecycleManager)this.injector.getInstance(LifecycleManager.class);
        try {
            manager.start();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        return this.injector;
    }

    public LifecycleTester withSuite(LifecycleInjectorBuilderSuite suite) {
        if (this.suites == null || this.suites.length == 0) {
            this.suites = new LifecycleInjectorBuilderSuite[]{suite};
        } else {
            this.suites = Arrays.copyOf(this.suites, this.suites.length + 1);
            this.suites[this.suites.length - 1] = suite;
        }
        return this;
    }

    public LifecycleInjectorBuilder builder() {
        return this.builder;
    }

    public <T> T getInstance(Class<T> type) {
        return (T)this.injector.getInstance(type);
    }

    public <T> T getInstance(Key<T> type) {
        return (T)this.injector.getInstance(type);
    }

    public <T> T getInstance(TypeLiteral<T> type) {
        return (T)this.injector.getInstance(Key.get(type));
    }

    protected void after() {
        if (this.injector != null) {
            LifecycleManager manager = (LifecycleManager)this.injector.getInstance(LifecycleManager.class);
            try {
                manager.close();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

