/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.test;

import com.google.inject.Scopes;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.reflect.Constructor;

public class CopyBindingTargetVisitor<T>
implements BindingTargetVisitor<T, Void> {
    private LinkedBindingBuilder<T> builder;

    public CopyBindingTargetVisitor(LinkedBindingBuilder<T> builder) {
        this.builder = builder;
    }

    public Void visit(InstanceBinding<? extends T> binding) {
        this.builder.toInstance(binding.getInstance());
        return null;
    }

    public Void visit(ProviderInstanceBinding<? extends T> binding) {
        this.builder.toProvider(binding.getProviderInstance()).in(Scopes.SINGLETON);
        return null;
    }

    public Void visit(ProviderKeyBinding<? extends T> binding) {
        this.builder.toProvider(binding.getProviderKey()).in(Scopes.SINGLETON);
        return null;
    }

    public Void visit(LinkedKeyBinding<? extends T> binding) {
        this.builder.to(binding.getLinkedKey()).in(Scopes.SINGLETON);
        return null;
    }

    public Void visit(ExposedBinding<? extends T> binding) {
        this.builder.to(binding.getKey()).in(Scopes.SINGLETON);
        return null;
    }

    public Void visit(UntargettedBinding<? extends T> binding) {
        this.builder.to(binding.getKey().getTypeLiteral()).in(Scopes.SINGLETON);
        return null;
    }

    public Void visit(ConstructorBinding<? extends T> binding) {
        this.builder.toConstructor((Constructor)binding.getConstructor().getMember()).in(Scopes.SINGLETON);
        return null;
    }

    public Void visit(ConvertedConstantBinding<? extends T> binding) {
        this.builder.toInstance(binding.getValue());
        return null;
    }

    public Void visit(ProviderBinding<? extends T> binding) {
        this.builder.toProvider(binding.getProvider()).in(Scopes.SINGLETON);
        return null;
    }
}

